/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.dataservices.sql.driver.TResultSetMetaData;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataCell;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;

public class TResultSet
implements ResultSet {
    private Statement stmt;
    private DataTable data;
    private int currentRowPosition = -1;
    private boolean isClosed = false;
    private ColumnInfo[] columns;
    private List<DataRow> rows;

    public TResultSet(Statement stmt, DataTable data, ColumnInfo[] columns) throws SQLException {
        this.stmt = stmt;
        this.data = data;
        this.columns = columns;
        Collection<DataRow> tmp = this.getData().getRows().values();
        this.rows = new ArrayList<DataRow>(tmp);
    }

    @Override
    public boolean next() throws SQLException {
        this.determineResultSetState();
        if (this.isFirst()) {
            this.currentRowPosition = 0;
        }
        ++this.currentRowPosition;
        return this.getCurrentRowPosition() - 1 < this.getRows().size();
    }

    @Override
    public void close() throws SQLException {
        this.determineResultSetState();
        this.data = null;
        this.isClosed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.determineResultSetState();
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.determineResultSetState();
        Object value = this.getValue(columnIndex);
        return value != null ? value.toString() : null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.determineResultSetState();
        return Boolean.parseBoolean(this.getValue(columnIndex).toString());
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.determineResultSetState();
        String value = this.getValue(columnIndex).toString();
        return Short.parseShort(value.substring(0, value.indexOf(".")));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.determineResultSetState();
        String value = this.getValue(columnIndex).toString();
        return Integer.parseInt(value.substring(0, value.indexOf(".")));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.determineResultSetState();
        return Long.parseLong(this.getValue(columnIndex).toString());
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.determineResultSetState();
        return Float.parseFloat(this.getValue(columnIndex).toString());
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.determineResultSetState();
        return Double.parseDouble(this.getValue(columnIndex).toString());
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.determineResultSetState();
        return BigDecimal.valueOf(Long.parseLong(this.getValue(columnIndex).toString()));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.determineResultSetState();
        return null;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        Object value = this.getValue(columnIndex);
        return value != null ? value.toString() : null;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return Boolean.parseBoolean(this.getValue(columnIndex).toString());
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        String value = this.getValue(columnIndex).toString();
        return Short.parseShort(value.substring(0, value.indexOf(".")));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        String value = this.getValue(columnIndex).toString();
        int tmp = value.indexOf(".");
        if (tmp == -1) {
            throw new SQLException("Invalid value to be returned as an integer");
        }
        return Integer.parseInt(value.substring(0, tmp));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return Long.parseLong(this.getValue(columnIndex).toString());
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return Float.parseFloat(this.getValue(columnIndex).toString());
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return Double.parseDouble(this.getValue(columnIndex).toString());
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        DataCell cell = this.getCurrentRow().getCells().get(columnIndex);
        if (cell == null) {
            throw new SQLException("Error occurred while extracting the value");
        }
        if (cell.getCellType() != 0) {
            throw new SQLException("Value cannot be cast to a string");
        }
        return BigDecimal.valueOf(Long.parseLong(cell.getCellValue().toString()));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public String getCursorName() throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.determineResultSetState();
        return new TResultSetMetaData(this.getColumns(), this.getColumns().length);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.determineResultSetState();
        DataCell cell = this.getCurrentRow().getCells().get(columnIndex);
        if (cell == null) {
            throw new SQLException("Error occurred while extracting the value");
        }
        return cell.getCellValue();
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        DataCell cell = this.getCurrentRow().getCells().get(columnIndex);
        if (cell == null) {
            throw new SQLException("Error occurred while extracting the value");
        }
        return cell.getCellValue();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.determineResultSetState();
        ColumnInfo o = this.getData().getHeader(columnLabel);
        if (o == null) {
            throw new SQLException("Invalid column name '" + columnLabel + "'");
        }
        return Integer.parseInt(o.toString());
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type not supported");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.determineResultSetState();
        return this.getCurrentRowPosition() == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.determineResultSetState();
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.determineResultSetState();
        return this.getCurrentRowPosition() == -1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.determineResultSetState();
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.determineResultSetState();
    }

    @Override
    public void afterLast() throws SQLException {
        this.determineResultSetState();
    }

    @Override
    public boolean first() throws SQLException {
        this.determineResultSetState();
        return this.getCurrentRowPosition() == 0;
    }

    @Override
    public boolean last() throws SQLException {
        this.determineResultSetState();
        return this.getCurrentRowPosition() == this.getRows().size() - 1;
    }

    @Override
    public int getRow() throws SQLException {
        this.determineResultSetState();
        return this.getCurrentRowPosition();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.determineResultSetState();
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.determineResultSetState();
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        this.determineResultSetState();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.determineResultSetState();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.determineResultSetState();
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.determineResultSetState();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.determineResultSetState();
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        this.determineResultSetState();
        return 0;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.determineResultSetState();
        return 0;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.determineResultSetState();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.determineResultSetState();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.determineResultSetState();
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public void insertRow() throws SQLException {
        this.determineResultSetState();
    }

    @Override
    public void updateRow() throws SQLException {
        this.determineResultSetState();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.determineResultSetState();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.determineResultSetState();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.determineResultSetState();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.determineResultSetState();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.determineResultSetState();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.determineResultSetState();
        return this.stmt;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation not supported");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Data type is not supported");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.determineResultSetState();
        throw new SQLFeatureNotSupportedException("Operation is not supported");
    }

    public int getCurrentRowPosition() {
        return this.currentRowPosition;
    }

    private DataTable getData() {
        return this.data;
    }

    private DataRow getCurrentRow() {
        return this.getRows().get(this.getCurrentRowPosition() - 1);
    }

    private List<DataRow> getRows() {
        return this.rows;
    }

    private void determineResultSetState() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result set has already been closed");
        }
    }

    public ColumnInfo[] getColumns() {
        return this.columns;
    }

    private Object getValue(int columnIndex) throws SQLException {
        DataCell cell = this.getCurrentRow().getCells().get(columnIndex);
        if (cell == null) {
            throw new SQLException("Error occurred while extracting the value");
        }
        return cell.getCellValue();
    }
}

