/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.create;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;
import org.wso2.carbon.dataservices.sql.driver.query.Query;

public abstract class CreateQuery
extends Query {
    private String tableName = this.extractTableName(this.getProcessedTokens());
    private List<ColumnInfo> columns = this.extractColumns(this.getProcessedTokens(), new ArrayList<ColumnInfo>());

    public CreateQuery(Statement stmt) throws SQLException {
        super(stmt);
    }

    private String extractTableName(Queue<String> tokens) {
        tokens.poll();
        tokens.poll();
        tokens.poll();
        return tokens.poll();
    }

    private List<ColumnInfo> extractColumns(Queue<String> tokens, List<ColumnInfo> columns) throws SQLException {
        if (tokens.isEmpty()) {
            return columns;
        }
        if (!"COLUMN".equals(tokens.peek())) {
            throw new SQLException("Unable to extract columns");
        }
        tokens.poll();
        columns.add(new ColumnInfo(tokens.poll(), this.getTableName(), -1));
        if ("COLUMN".equals(tokens.peek())) {
            columns = this.extractColumns(tokens, columns);
        }
        return columns;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }
}

