/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.insert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.wso2.carbon.dataservices.sql.driver.TCustomConnection;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataCell;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable;
import org.wso2.carbon.dataservices.sql.driver.query.ParamInfo;
import org.wso2.carbon.dataservices.sql.driver.query.insert.InsertQuery;

public class CustomInsertQuery
extends InsertQuery {
    public CustomInsertQuery(Statement stmt) throws SQLException {
        super(stmt);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeUpdate();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (!(this.getConnection() instanceof TCustomConnection)) {
            throw new SQLException("Connection does not refer to a Custom connection");
        }
        DataTable table = ((TCustomConnection)this.getConnection()).getDataSource().getDataTable(this.getTargetTableName());
        if (table == null) {
            throw new SQLException("The custom data table '" + this.getTargetTableName() + "' does not exist");
        }
        DataRow row = new DataRow(0);
        HashMap<Integer, DataCell> cells = new HashMap<Integer, DataCell>();
        for (ParamInfo param : this.getParameters()) {
            cells.put(param.getOrdinal(), new DataCell(param.getOrdinal(), param.getSqlType(), param.getValue()));
        }
        row.setCells(cells);
        table.addRow(row);
        return 1;
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeUpdate();
        return true;
    }
}

