/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.gdata.client.Query;
import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.IFeed;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.sql.driver.TDriverUtil;
import org.wso2.carbon.dataservices.sql.driver.internal.SQLDriverDSComponent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class GSpreadFeedProcessor {
    private static final Log log = LogFactory.getLog(GSpreadFeedProcessor.class);
    private String clientId;
    private String clientSecret;
    private String accessToken;
    private String refreshToken;
    private String visibility = "private";
    private SpreadsheetService service;
    private String charSetType = "UTF-8";
    private String baseRegistryOauthTokenPath = "/repository/components/org.wso2.carbon.dataservices.sql.driver/tokens/";

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setService(SpreadsheetService service) {
        this.service = service;
    }

    public SpreadsheetService getService() {
        return this.service;
    }

    public GSpreadFeedProcessor(String clientId, String clientSecret, String refReshToken, String visibility, String baseRegistryOauthTokenPath) throws SQLException {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.refreshToken = refReshToken;
        this.visibility = visibility;
        if (!this.checkVisibility()) {
            throw new SQLException("Invalid access mode '" + visibility + "' is provided");
        }
        if (this.requiresAuth()) {
            if (this.clientId == null || this.clientId.isEmpty()) {
                throw new SQLException("Valid Client id not provided");
            }
            if (this.clientSecret == null || this.clientSecret.isEmpty()) {
                throw new SQLException("Valid Client secret not provided");
            }
            if (this.refreshToken == null || this.refreshToken.isEmpty()) {
                throw new SQLException("Valid refresh token not provided");
            }
            try {
                this.clientId = URLDecoder.decode(this.clientId, "UTF-8");
                this.clientSecret = URLDecoder.decode(this.clientSecret, "UTF-8");
                this.refreshToken = URLDecoder.decode(this.refreshToken, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Error in retrieving Authentication information " + e.getMessage(), e);
            }
        }
        this.baseRegistryOauthTokenPath = baseRegistryOauthTokenPath;
    }

    public <E extends IEntry> E insert(URL feedUrl, E entry) throws SQLException {
        try {
            if (this.requiresAuth()) {
                block8: {
                    if (this.accessToken != null) {
                        this.authenticateWithAccessToken();
                        try {
                            return (E)this.service.insert(feedUrl, entry);
                        }
                        catch (Exception e) {
                            log.warn((Object)"GSpreadConfig.getFeed(): Failed to retrieve Feeds with current AccessToken ", (Throwable)e);
                            String accessTokenFromRegistry = this.getAccessTokenFromRegistry();
                            if (accessTokenFromRegistry == null || this.accessToken == accessTokenFromRegistry) break block8;
                            this.accessToken = accessTokenFromRegistry;
                            this.authenticateWithAccessToken();
                            try {
                                return (E)this.service.insert(feedUrl, entry);
                            }
                            catch (Exception e2) {
                                log.warn((Object)"GSpreadConfig.getFeed(): Failed to retrieve Feeds with AccessToken from registry ", (Throwable)e2);
                            }
                        }
                    }
                }
                this.refreshAndAuthenticate();
                this.saveTokenToRegistry();
            }
            return (E)this.service.insert(feedUrl, entry);
        }
        catch (Exception e) {
            throw new SQLException("Error in retrieving Feed data " + e.getMessage(), e);
        }
    }

    public <F extends IFeed> F getFeed(URL feedUrl, Class<F> feedClass) throws SQLException {
        try {
            if (this.requiresAuth()) {
                block8: {
                    if (this.accessToken != null) {
                        this.authenticateWithAccessToken();
                        try {
                            return (F)this.service.getFeed(feedUrl, feedClass);
                        }
                        catch (Exception e) {
                            log.warn((Object)"GSpreadConfig.getFeed(): Failed to retrieve Feeds with current AccessToken ", (Throwable)e);
                            String accessTokenFromRegistry = this.getAccessTokenFromRegistry();
                            if (accessTokenFromRegistry == null || this.accessToken.equals(accessTokenFromRegistry)) break block8;
                            this.accessToken = accessTokenFromRegistry;
                            this.authenticateWithAccessToken();
                            try {
                                return (F)this.service.getFeed(feedUrl, feedClass);
                            }
                            catch (Exception e2) {
                                log.warn((Object)"GSpreadConfig.getFeed(): Failed to retrieve Feeds with AccessToken from registry ", (Throwable)e2);
                            }
                        }
                    }
                }
                this.refreshAndAuthenticate();
                this.saveTokenToRegistry();
            }
            return (F)this.service.getFeed(feedUrl, feedClass);
        }
        catch (Exception e) {
            throw new SQLException("Error in retrieving Feed data " + e.getMessage(), e);
        }
    }

    public <F extends IFeed> F getFeed(Query query, Class<F> feedClass) throws SQLException {
        try {
            if (this.requiresAuth()) {
                block8: {
                    if (this.accessToken != null) {
                        this.authenticateWithAccessToken();
                        try {
                            return (F)this.service.getFeed(query, feedClass);
                        }
                        catch (Exception e) {
                            log.warn((Object)"GSpreadConfig.getFeed(): Failed to retrieve Feeds with current AccessToken ", (Throwable)e);
                            String accessTokenFromRegistry = this.getAccessTokenFromRegistry();
                            if (accessTokenFromRegistry == null || this.accessToken.equals(accessTokenFromRegistry)) break block8;
                            this.accessToken = accessTokenFromRegistry;
                            this.authenticateWithAccessToken();
                            try {
                                return (F)this.service.getFeed(query, feedClass);
                            }
                            catch (Exception e2) {
                                log.warn((Object)"GSpreadConfig.getFeed(): Failed to retrieve Feeds with AccessToken from registry ", (Throwable)e2);
                            }
                        }
                    }
                }
                this.refreshAndAuthenticate();
                this.saveTokenToRegistry();
            }
            return (F)this.service.getFeed(query, feedClass);
        }
        catch (Exception e) {
            throw new SQLException("Error in retrieving Feed data " + e.getMessage(), e);
        }
    }

    private void authenticateWithAccessToken() {
        GoogleCredential credential = this.getBaseCredential();
        credential.setAccessToken(this.accessToken);
        this.service.setOAuth2Credentials((Credential)credential);
    }

    private void refreshAndAuthenticate() throws Exception {
        GoogleCredential credential = this.getBaseCredential();
        credential.setAccessToken(this.accessToken);
        credential.setRefreshToken(this.refreshToken);
        credential.refreshToken();
        this.accessToken = credential.getAccessToken();
        this.service.setOAuth2Credentials((Credential)credential);
    }

    private GoogleCredential getBaseCredential() {
        NetHttpTransport httpTransport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        GoogleCredential credential = new GoogleCredential.Builder().setClientSecrets(this.clientId, this.clientSecret).setTransport((HttpTransport)httpTransport).setJsonFactory((JsonFactory)jsonFactory).build();
        return credential;
    }

    private String generateAuthTokenResourcePath() {
        String resPath = this.baseRegistryOauthTokenPath + "configs/" + "user_auth_token/users/" + this.clientId;
        return resPath;
    }

    private Resource getAuthTokenResource(Registry registry) throws Exception {
        if (registry == null) {
            return null;
        }
        String resPath = this.generateAuthTokenResourcePath();
        if (!registry.resourceExists(resPath)) {
            return null;
        }
        return registry.get(resPath);
    }

    private String getAccessTokenFromRegistry() throws Exception {
        Object content;
        if (SQLDriverDSComponent.getRegistryService() == null) {
            String msg = "GSpreadConfig.getFeed(): Registry service is not available, authentication key sharing fails";
            throw new SQLException(msg);
        }
        UserRegistry registry = SQLDriverDSComponent.getRegistryService().getGovernanceSystemRegistry(TDriverUtil.getCurrentTenantId());
        Resource authTokenRes = this.getAuthTokenResource((Registry)registry);
        if (authTokenRes != null && (content = authTokenRes.getContent()) != null) {
            return new String((byte[])content, this.charSetType);
        }
        return null;
    }

    private void saveTokenToRegistry() throws Exception {
        if (SQLDriverDSComponent.getRegistryService() == null) {
            String msg = "GSpreadConfig.getFeed(): Registry service is not available, authentication key cannot be saved";
            throw new SQLException(msg);
        }
        UserRegistry registry = SQLDriverDSComponent.getRegistryService().getGovernanceSystemRegistry(TDriverUtil.getCurrentTenantId());
        registry.beginTransaction();
        Resource res = registry.newResource();
        res.setContent((Object)this.accessToken.getBytes(this.charSetType));
        registry.put(this.generateAuthTokenResourcePath(), res);
        registry.commitTransaction();
    }

    public URL getSpreadSheetFeedUrl() throws MalformedURLException {
        return new URL("https://spreadsheets.google.com/feeds/spreadsheets/" + this.visibility + "/full");
    }

    public URL generateWorksheetFeedURL(String key) throws MalformedURLException {
        return new URL("https://spreadsheets.google.com/feeds/worksheets/" + key + "/" + this.visibility + "/basic");
    }

    public boolean requiresAuth() {
        return this.visibility != null && this.visibility.equals("private");
    }

    private boolean checkVisibility() {
        return "private".equals(this.visibility) || "public".equals(this.visibility);
    }
}

