/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.processor.reader;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;

public class FixedDataTable
extends DataTable {
    private Map<Integer, DataRow> rows = Collections.synchronizedMap(new TreeMap());

    public FixedDataTable(String tableName, ColumnInfo[] headers) {
        super(tableName, headers);
    }

    @Override
    public Map<Integer, DataRow> getRows() {
        return this.rows;
    }

    public void setData(Map<Integer, DataRow> rows) {
        this.rows = rows;
    }

    @Override
    public void addRow(DataRow dataRow) {
        this.getRows().put(dataRow.getRowId(), dataRow);
    }

    private void handleEqualCondition(Map<Integer, DataRow> dataRows, int cellId, String value, String operator) {
        double tmpNumberRhs = 0.0;
        boolean isNumber = true;
        try {
            tmpNumberRhs = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            isNumber = false;
        }
        Iterator<Map.Entry<Integer, DataRow>> itr = dataRows.entrySet().iterator();
        while (itr.hasNext()) {
            DataRow tmpRow = itr.next().getValue();
            try {
                if (isNumber) {
                    double tmpNumberLhs = Double.parseDouble(tmpRow.getCell(cellId).getCellValue().toString());
                    if (tmpNumberLhs == tmpNumberRhs) continue;
                    itr.remove();
                    continue;
                }
            }
            catch (NumberFormatException e) {
                isNumber = false;
            }
            if (value.equals(tmpRow.getCell(cellId).getCellValue())) continue;
            itr.remove();
        }
    }

    private void handleLessThanCondition(Map<Integer, DataRow> dataRows, int cellId, String value, String operator) {
        double tmpNumberRhs;
        try {
            tmpNumberRhs = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            dataRows.clear();
            return;
        }
        Iterator<Map.Entry<Integer, DataRow>> itr = dataRows.entrySet().iterator();
        while (itr.hasNext()) {
            DataRow tmpRow = itr.next().getValue();
            try {
                double tmpNumberLhs = Double.parseDouble(tmpRow.getCell(cellId).getCellValue().toString());
                if (tmpNumberLhs < tmpNumberRhs) continue;
                itr.remove();
            }
            catch (NumberFormatException e) {
                itr.remove();
            }
        }
    }

    private void handleGreaterThanCondition(Map<Integer, DataRow> dataRows, int cellId, String value, String operator) {
        double tmpNumberRhs;
        try {
            tmpNumberRhs = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            dataRows.clear();
            return;
        }
        Iterator<Map.Entry<Integer, DataRow>> itr = dataRows.entrySet().iterator();
        while (itr.hasNext()) {
            DataRow tmpRow = itr.next().getValue();
            try {
                double tmpNumberLhs = Double.parseDouble(tmpRow.getCell(cellId).getCellValue().toString());
                if (tmpNumberLhs > tmpNumberRhs) continue;
                itr.remove();
            }
            catch (NumberFormatException e) {
                itr.remove();
            }
        }
    }

    @Override
    public Map<Integer, DataRow> applyCondition(String column, String value, String operator) throws SQLException {
        HashMap<Integer, DataRow> dataRows = new HashMap<Integer, DataRow>(this.getRows());
        int cellId = this.getHeader(column).getId();
        if ("=".equals(operator)) {
            this.handleEqualCondition(dataRows, cellId, value, operator);
        } else if (">".equals(operator)) {
            this.handleGreaterThanCondition(dataRows, cellId, value, operator);
        } else if ("<".equals(operator)) {
            this.handleLessThanCondition(dataRows, cellId, value, operator);
        } else {
            throw new RuntimeException("Unsupported operator: " + operator);
        }
        return dataRows;
    }

    @Override
    public void updateRows(DataRow ... dataRows) {
        for (DataRow dataRow : dataRows) {
            this.getRows().put(dataRow.getRowId(), dataRow);
        }
    }

    @Override
    public void deleteRows(int ... rowIds) {
        for (int rowId : rowIds) {
            this.getRows().remove(rowId);
        }
    }
}

