/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.insert;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.wso2.carbon.dataservices.sql.driver.TDriverUtil;
import org.wso2.carbon.dataservices.sql.driver.parser.ParserUtil;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;
import org.wso2.carbon.dataservices.sql.driver.query.Query;

public abstract class InsertQuery
extends Query {
    private String targetTableName = this.extractTargetTableName(this.getProcessedTokens());
    private Map<Integer, String> columns = this.extractTargetColumns(this.getProcessedTokens());
    private Map<Integer, Object> columnValues = this.extractTargetColumnValues(this.getProcessedTokens());

    public InsertQuery(Statement stmt) throws SQLException {
        super(stmt);
        if (this.getColumns().size() != this.getColumnValues().size()) {
            throw new SQLException("Parameter index is out of range. The column count does not match the value count");
        }
    }

    private String extractTargetTableName(Queue<String> tokens) throws SQLException {
        if (tokens == null || tokens.isEmpty()) {
            throw new SQLException("Unable to populate attributes");
        }
        tokens.poll();
        tokens.poll();
        if (!"TABLE".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("Table name is missing");
        }
        tokens.poll();
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Table name is missing");
        }
        return tokens.poll();
    }

    private Map<Integer, String> extractTargetColumns(Queue<String> tokens) throws SQLException {
        Map<Integer, String> targetColumns = new HashMap<Integer, String>();
        if ("COLUMN".equals(tokens.peek())) {
            this.processColumnNames(tokens, targetColumns, 0);
        } else {
            targetColumns = this.getColumnMap();
        }
        return targetColumns;
    }

    private Map<Integer, Object> extractTargetColumnValues(Queue<String> tokens) throws SQLException {
        HashMap<Integer, Object> targetColumnValues = new HashMap<Integer, Object>();
        if (!"VALUES".equalsIgnoreCase(tokens.peek()) && !"VALUE".equalsIgnoreCase(tokens.peek())) {
            throw new SQLException("VALUE/VALUES keyword is missing");
        }
        tokens.poll();
        this.processColumnValues(tokens, targetColumnValues, 0, false, false, true);
        return targetColumnValues;
    }

    private void processColumnNames(Queue<String> tokens, Map<Integer, String> targetColumns, int colCount) throws SQLException {
        if (!"COLUMN".equalsIgnoreCase(tokens.peek())) {
            return;
        }
        tokens.poll();
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal expected");
        }
        targetColumns.put(colCount, tokens.poll());
        if ("COLUMN".equalsIgnoreCase(tokens.peek())) {
            this.processColumnNames(tokens, targetColumns, colCount + 1);
        }
    }

    private void processColumnValues(Queue<String> tokens, Map<Integer, Object> targetColumnValues, int valCount, boolean isParameterized, boolean isEnd, boolean isInit) throws SQLException {
        if (!isEnd) {
            if (!"PARAM_VALUE".equalsIgnoreCase(tokens.peek())) {
                throw new SQLException("Syntax Error : 'PARAM_VALUE' is expected");
            }
            tokens.poll();
            if (!ParserUtil.isStringLiteral(tokens.peek())) {
                throw new SQLException("Syntax Error : String literal expected");
            }
            if ("?".equalsIgnoreCase(tokens.peek())) {
                if (isInit) {
                    isParameterized = true;
                    isInit = false;
                }
                if (!isParameterized) {
                    throw new SQLException("Both parameters and inline parameter values are not allowed to exist together");
                }
                isParameterized = true;
                targetColumnValues.put(valCount, tokens.poll());
            } else if ("'".equalsIgnoreCase(tokens.peek())) {
                if (isInit) {
                    isInit = false;
                    isParameterized = false;
                }
                if (isParameterized) {
                    throw new SQLException("Both parameters and inline parameter values are not allowed to exist together");
                }
                tokens.poll();
                StringBuilder b = new StringBuilder();
                while ("'".equalsIgnoreCase(tokens.peek()) || tokens.isEmpty()) {
                    b.append(tokens.poll());
                }
                targetColumnValues.put(valCount, b.toString());
                tokens.poll();
            } else if (ParserUtil.isStringLiteral(tokens.peek())) {
                if (isInit) {
                    isInit = false;
                    isParameterized = false;
                }
                if (isParameterized) {
                    throw new SQLException("Both parameters and inline parameter values are not allowed to exist together");
                }
                targetColumnValues.put(valCount, tokens.poll());
            }
            if (!"PARAM_VALUE".equalsIgnoreCase(tokens.peek())) {
                isEnd = true;
            }
            this.processColumnValues(tokens, targetColumnValues, valCount + 1, isParameterized, isEnd, isInit);
        }
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public Map<Integer, String> getColumns() {
        return this.columns;
    }

    public Map<Integer, Object> getColumnValues() {
        return this.columnValues;
    }

    private Map<Integer, String> getColumnMap() throws SQLException {
        ColumnInfo[] headers = TDriverUtil.getHeaders(this.getConnection(), this.getTargetTableName());
        HashMap<Integer, String> columns = new HashMap<Integer, String>();
        for (ColumnInfo column : headers) {
            columns.put(column.getId(), column.getName());
        }
        return columns;
    }
}

