/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.update;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.wso2.carbon.dataservices.sql.driver.TDriverUtil;
import org.wso2.carbon.dataservices.sql.driver.TExcelConnection;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;
import org.wso2.carbon.dataservices.sql.driver.query.update.UpdateQuery;

public class ExcelUpdateQuery
extends UpdateQuery {
    public ExcelUpdateQuery(Statement stmt) throws SQLException {
        super(stmt);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeSQL();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeSQL();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeSQL() > 0;
    }

    private int executeSQL() throws SQLException {
        Map<Integer, DataRow> result = this.getCondition().getLhs() == null && this.getCondition().getRhs() == null ? this.getTargetTable().getRows() : this.getCondition().process(this.getTargetTable());
        if (!(this.getConnection() instanceof TExcelConnection)) {
            throw new SQLException("Connection does not refer to a Excel connection");
        }
        TExcelConnection excelConnection = (TExcelConnection)this.getConnection();
        excelConnection.beginExcelTransaction();
        Workbook workbook = excelConnection.getWorkbook();
        Sheet sheet = workbook.getSheet(this.getTargetTableName());
        if (sheet == null) {
            throw new SQLException("Excel sheet named '" + this.getTargetTableName() + "' does not exist");
        }
        ColumnInfo[] headers = TDriverUtil.getHeaders(this.getConnection(), this.getTargetTableName());
        for (Map.Entry<Integer, DataRow> row : result.entrySet()) {
            Row updatedRow = sheet.getRow(row.getKey() + 1);
            for (ColumnInfo column : this.getTargetColumns()) {
                int columnId = this.findColumnId(headers, column.getName());
                updatedRow.getCell(columnId).setCellValue(column.getValue().toString());
            }
        }
        TDriverUtil.writeRecords(workbook, ((TExcelConnection)this.getConnection()).getPath());
        return 0;
    }

    private int findColumnId(ColumnInfo[] headers, String headerName) throws SQLException {
        ColumnInfo column = null;
        for (ColumnInfo header : headers) {
            if (!headerName.equalsIgnoreCase(header.getName())) continue;
            column = header;
        }
        if (column == null) {
            throw new SQLException("Column '" + headerName + "' does not exist");
        }
        return column.getId();
    }
}

