/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.delete;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Queue;
import org.wso2.carbon.dataservices.sql.driver.parser.ParserUtil;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataReaderFactory;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable;
import org.wso2.carbon.dataservices.sql.driver.query.ConditionalQuery;

public abstract class DeleteQuery
extends ConditionalQuery {
    private String targetTableName = this.extractTargetTableName(this.getProcessedTokens());
    private DataTable targetTable = DataReaderFactory.createDataReader(this.getConnection()).getDataTable(this.getTargetTableName());

    public DeleteQuery(Statement stmt) throws SQLException {
        super(stmt);
        this.populateConditions(this.getProcessedTokens());
    }

    private String extractTargetTableName(Queue<String> tokens) throws SQLException {
        tokens.poll();
        tokens.poll();
        tokens.poll();
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal is expected");
        }
        return tokens.poll();
    }

    private void populateConditions(Queue<String> tokens) throws SQLException {
        if (tokens.isEmpty()) {
            return;
        }
        tokens.poll();
        this.processConditions(tokens, this.getCondition());
    }

    public DataTable getTargetTable() {
        return this.targetTable;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public Map<Integer, DataRow> getResultantRows() throws SQLException {
        Map<Integer, DataRow> result = this.getCondition().getLhs() == null && this.getCondition().getRhs() == null ? this.getTargetTable().getRows() : this.getCondition().process(this.getTargetTable());
        return result;
    }
}

