/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.processor.reader;

import java.sql.SQLException;
import java.util.Map;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;

public abstract class DataTable {
    private String tableName;
    private ColumnInfo[] headers;
    private boolean hasHeader;

    public DataTable(String tableName, boolean hasHeader) {
        this.tableName = tableName;
        this.hasHeader = hasHeader;
    }

    public DataTable(String tableName, ColumnInfo[] headers) {
        this.tableName = tableName;
        this.headers = headers;
        try {
            if (this.getHeaders() != null && this.getHeaders().length > 0) {
                this.hasHeader = true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public abstract Map<Integer, DataRow> getRows() throws SQLException;

    public abstract void addRow(DataRow var1) throws SQLException;

    public abstract void updateRows(DataRow ... var1) throws SQLException;

    public abstract void deleteRows(int ... var1) throws SQLException;

    public abstract Map<Integer, DataRow> applyCondition(String var1, String var2, String var3) throws SQLException;

    public String getTableName() {
        return this.tableName;
    }

    public ColumnInfo[] getHeaders() throws SQLException {
        return this.headers;
    }

    public void setHeaders(ColumnInfo[] headers) {
        this.headers = headers;
    }

    public boolean hasHeader() {
        return this.hasHeader;
    }

    public ColumnInfo getHeader(String name) throws SQLException {
        ColumnInfo result = null;
        for (ColumnInfo column : this.getHeaders()) {
            if (!column.getName().equalsIgnoreCase(name)) continue;
            result = column;
        }
        return result;
    }
}

