/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver;

import com.google.gdata.client.Query;
import com.google.gdata.client.spreadsheet.SpreadsheetQuery;
import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.client.spreadsheet.WorksheetQuery;
import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.SpreadsheetFeed;
import com.google.gdata.data.spreadsheet.WorksheetFeed;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.sql.driver.TConnection;
import org.wso2.carbon.dataservices.sql.driver.TDriverUtil;
import org.wso2.carbon.dataservices.sql.driver.TPreparedStatement;
import org.wso2.carbon.dataservices.sql.driver.util.GSpreadFeedProcessor;

public class TGSpreadConnection
extends TConnection {
    private static final Log log = LogFactory.getLog(TGSpreadConnection.class);
    private String spreadSheetName;
    private SpreadsheetFeed spreadSheetFeed;
    private WorksheetFeed worksheetFeed;
    private GSpreadFeedProcessor feedProcessor;

    public TGSpreadConnection(Properties props) throws SQLException {
        super(props);
        this.spreadSheetName = props.getProperty("sheetName");
        String visibility = props.getProperty("visibility");
        visibility = visibility != null ? visibility : "private";
        String clientId = props.getProperty("clientId");
        String clientSecret = props.getProperty("clientSecret");
        String refreshToken = props.getProperty("refreshToken");
        this.feedProcessor = new GSpreadFeedProcessor(clientId, clientSecret, refreshToken, visibility, "https://spreadsheets.google.com/feeds/spreadsheets/");
        if (this.feedProcessor.requiresAuth()) {
            try {
                this.feedProcessor.setClientId(URLDecoder.decode(this.feedProcessor.getClientId(), "UTF-8"));
                this.feedProcessor.setClientSecret(URLDecoder.decode(this.feedProcessor.getClientSecret(), "UTF-8"));
                this.feedProcessor.setRefreshToken(URLDecoder.decode(this.feedProcessor.getRefreshToken(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Error in retrieving Authentication information " + e.getMessage(), e);
            }
        }
        if (this.spreadSheetName == null) {
            throw new SQLException("Spread Sheet name is not provided");
        }
        SpreadsheetService service = new SpreadsheetService("WSO2SQLDriver");
        service.setCookieManager(null);
        this.feedProcessor.setService(service);
        this.spreadSheetFeed = this.extractSpreadSheetFeed();
        this.worksheetFeed = this.extractWorkSheetFeed();
    }

    public String getSpreadSheetName() {
        return this.spreadSheetName;
    }

    public GSpreadFeedProcessor getFeedProcessor() {
        return this.feedProcessor;
    }

    public WorksheetFeed getWorksheetFeed() {
        return this.worksheetFeed;
    }

    public SpreadsheetFeed getSpreadSheetFeed() {
        return this.spreadSheetFeed;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("CallableStatements are not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("CallableStatements are not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("CallableStatements are not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    private WorksheetFeed extractWorkSheetFeed() throws SQLException {
        SpreadsheetEntry spreadsheetEntry;
        if (this.getSpreadSheetFeed() == null) {
            throw new SQLException("Spread Sheet Feed is null");
        }
        List entries = this.getSpreadSheetFeed().getEntries();
        SpreadsheetEntry spreadsheetEntry2 = spreadsheetEntry = entries != null && entries.size() > 0 ? (SpreadsheetEntry)entries.get(0) : this.extractSpreadSheetEntryFromUrl();
        if (spreadsheetEntry == null) {
            throw new SQLException("No SpreadSheetEntry is available, matching provided connection information");
        }
        WorksheetQuery worksheetQuery = TDriverUtil.createWorkSheetQuery(spreadsheetEntry.getWorksheetFeedUrl());
        return this.feedProcessor.getFeed((Query)worksheetQuery, WorksheetFeed.class);
    }

    private SpreadsheetEntry extractSpreadSheetEntryFromUrl() throws SQLException {
        try {
            URL spreadSheetFeedUrl = this.feedProcessor.getSpreadSheetFeedUrl();
            SpreadsheetFeed feed = this.feedProcessor.getFeed(spreadSheetFeedUrl, SpreadsheetFeed.class);
            List entries = feed.getEntries();
            return entries != null && entries.size() > 0 ? (SpreadsheetEntry)entries.get(0) : null;
        }
        catch (Exception e) {
            throw new SQLException("Error occurred while extracting spread sheet entry", e);
        }
    }

    private SpreadsheetFeed extractSpreadSheetFeed() throws SQLException {
        URL spreadSheetFeedUrl;
        try {
            spreadSheetFeedUrl = this.feedProcessor.getSpreadSheetFeedUrl();
        }
        catch (MalformedURLException e) {
            throw new SQLException("Error occurred while constructing the Spread Sheet Feed URL");
        }
        SpreadsheetQuery spreadSheetQuery = TDriverUtil.createSpreadSheetQuery(this.getSpreadSheetName(), spreadSheetFeedUrl);
        return this.feedProcessor.getFeed((Query)spreadSheetQuery, SpreadsheetFeed.class);
    }
}

