/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.wso2.carbon.dataservices.sql.driver.TConnection;
import org.wso2.carbon.dataservices.sql.driver.TPreparedStatement;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable;

public class TCustomConnection
extends TConnection {
    public static final String CUSTOM_DATASOURCE = "__CUSTOM_DATASOURCE__";
    private CustomDataSource dataSource;

    public TCustomConnection(Properties props) throws SQLException {
        super(props);
        this.dataSource = (CustomDataSource)props.get(CUSTOM_DATASOURCE);
        if (this.dataSource == null) {
            throw new SQLException("Custom data source object not available in properties");
        }
    }

    public CustomDataSource getDataSource() {
        return this.dataSource;
    }

    public Statement createStatement(String sql) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new TPreparedStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("CallableStatements are not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("CallableStatements are not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("CallableStatements are not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    public static interface CustomDataSource {
        public void init(Properties var1) throws SQLException;

        public Set<String> getDataTableNames() throws SQLException;

        public DataTable getDataTable(String var1) throws SQLException;

        public void createDataTable(String var1, Map<String, Integer> var2) throws SQLException;

        public void dropDataTable(String var1) throws SQLException;
    }
}

