/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.wso2.carbon.dataservices.sql.driver.TPreparedStatement;
import org.wso2.carbon.dataservices.sql.driver.query.ParamInfo;

public abstract class Query {
    private Statement stmt;
    private Connection connection;
    private Queue<String> processedTokens;
    private ParamInfo[] parameters;

    public Query(Statement stmt) throws SQLException {
        this.stmt = stmt;
        this.connection = stmt.getConnection();
        this.processedTokens = ((TPreparedStatement)this.getStatement()).getProcessedTokens();
        this.parameters = ((TPreparedStatement)this.getStatement()).getParameters();
        ArrayList<String> tokens = new ArrayList<String>(this.processedTokens);
        this.processedTokens = this.mergeParameterValues(tokens.toArray(new String[tokens.size()]), this.parameters);
    }

    public abstract ResultSet executeQuery() throws SQLException;

    public abstract int executeUpdate() throws SQLException;

    public abstract boolean execute() throws SQLException;

    private Queue<String> mergeParameterValues(String[] tokens, ParamInfo[] parameters) {
        int paramIndex = 0;
        for (int i = 0; i < tokens.length; ++i) {
            if (!"?".equals(tokens[i])) continue;
            ParamInfo parameter = parameters[paramIndex];
            switch (parameter.getSqlType()) {
                case 2: 
                case 4: {
                    tokens[i] = parameter.getValue().toString();
                    break;
                }
                case 12: {
                    tokens[i] = parameter.getValue().toString();
                }
            }
            ++paramIndex;
        }
        return new ConcurrentLinkedQueue<String>(Arrays.asList(tokens));
    }

    public ParamInfo findParam(int index) {
        ParamInfo param = null;
        for (ParamInfo paramInfo : this.getParameters()) {
            if (paramInfo.getOrdinal() != index) continue;
            param = paramInfo;
            break;
        }
        return param;
    }

    public Statement getStatement() {
        return this.stmt;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Queue<String> getProcessedTokens() {
        return this.processedTokens;
    }

    public ParamInfo[] getParameters() {
        return this.parameters;
    }
}

