/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.update;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.wso2.carbon.dataservices.sql.driver.TCustomConnection;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;
import org.wso2.carbon.dataservices.sql.driver.query.update.UpdateQuery;

public class CustomUpdateQuery
extends UpdateQuery {
    public CustomUpdateQuery(Statement stmt) throws SQLException {
        super(stmt);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeUpdate();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (!(this.getConnection() instanceof TCustomConnection)) {
            throw new SQLException("Connection does not refer to a Custom connection");
        }
        DataTable table = ((TCustomConnection)this.getConnection()).getDataSource().getDataTable(this.getTargetTableName());
        if (table == null) {
            throw new SQLException("The custom data table '" + this.getTargetTableName() + "' does not exist");
        }
        Map<Integer, DataRow> result = this.getCondition().getLhs() == null && this.getCondition().getRhs() == null ? this.getTargetTable().getRows() : this.getCondition().process(this.getTargetTable());
        for (Map.Entry<Integer, DataRow> entry : result.entrySet()) {
            DataRow row = entry.getValue();
            for (ColumnInfo column : this.getTargetColumns()) {
                if (column == null) continue;
                row.getCell(table.getHeader(column.getName()).getId()).setCellValue(this.findParam(column.getOrdinal()).getValue());
            }
            table.updateRows(row);
        }
        return result.keySet().size();
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeUpdate();
        return true;
    }
}

