/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.insert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.wso2.carbon.dataservices.sql.driver.TDriverUtil;
import org.wso2.carbon.dataservices.sql.driver.TExcelConnection;
import org.wso2.carbon.dataservices.sql.driver.query.ParamInfo;
import org.wso2.carbon.dataservices.sql.driver.query.insert.InsertQuery;

public class ExcelInsertQuery
extends InsertQuery {
    public ExcelInsertQuery(Statement stmt) throws SQLException {
        super(stmt);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeSQL();
        return null;
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeSQL() > 0;
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeSQL();
    }

    private synchronized int executeSQL() throws SQLException {
        int rowCount = 0;
        if (!(this.getConnection() instanceof TExcelConnection)) {
            throw new SQLException("Connection does not refer to a Excel connection");
        }
        TExcelConnection excelConnection = (TExcelConnection)this.getConnection();
        excelConnection.beginExcelTransaction();
        Workbook workbook = excelConnection.getWorkbook();
        Sheet sheet = workbook.getSheet(this.getTargetTableName());
        if (sheet == null) {
            throw new SQLException("Excel sheet named '" + this.getTargetTableName() + "' does not exist");
        }
        int lastRowNo = sheet.getLastRowNum();
        if (this.getParameters() != null) {
            Row row = sheet.createRow(lastRowNo + 1);
            block7: for (ParamInfo param : this.getParameters()) {
                Cell cell = row.createCell(param.getOrdinal());
                switch (param.getSqlType()) {
                    case 12: {
                        cell.setCellValue((String)param.getValue());
                        continue block7;
                    }
                    case 4: {
                        cell.setCellValue((double)((Integer)param.getValue()).intValue());
                        continue block7;
                    }
                    case 8: {
                        cell.setCellValue(((Double)param.getValue()).doubleValue());
                        continue block7;
                    }
                    case 16: {
                        cell.setCellValue(((Boolean)param.getValue()).booleanValue());
                        continue block7;
                    }
                    case 91: {
                        cell.setCellValue((Date)param.getValue());
                        continue block7;
                    }
                    default: {
                        cell.setCellValue((String)param.getValue());
                    }
                }
            }
            ++rowCount;
        }
        TDriverUtil.writeRecords(workbook, ((TExcelConnection)this.getConnection()).getPath());
        return rowCount;
    }
}

