/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.query.update;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.wso2.carbon.dataservices.sql.driver.parser.ParserUtil;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataReaderFactory;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;
import org.wso2.carbon.dataservices.sql.driver.query.ConditionalQuery;

public abstract class UpdateQuery
extends ConditionalQuery {
    private String targetTableName = this.extractTargetTableName(this.getProcessedTokens());
    private DataTable targetTable;
    private ColumnInfo[] targetColumns = this.extractUpdatedColumns(this.getProcessedTokens());

    public UpdateQuery(Statement stmt) throws SQLException {
        super(stmt);
        this.populateConditions(this.getProcessedTokens());
        this.targetTable = DataReaderFactory.createDataReader(this.getConnection()).getDataTable(this.getTargetTableName());
    }

    private String extractTargetTableName(Queue<String> tokens) throws SQLException {
        tokens.poll();
        if (!"TABLE".equals(tokens.peek())) {
            throw new SQLException("Syntax Error : 'TABLE' keyword is expected");
        }
        tokens.poll();
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal is expected");
        }
        return tokens.poll();
    }

    private ColumnInfo[] extractUpdatedColumns(Queue<String> tokens) throws SQLException {
        tokens.poll();
        ArrayList<ColumnInfo> updatedColumns = new ArrayList<ColumnInfo>();
        this.processUpdatedColumns(tokens, updatedColumns, 0);
        return updatedColumns.toArray(new ColumnInfo[updatedColumns.size()]);
    }

    private void populateConditions(Queue<String> tokens) throws SQLException {
        if (tokens.isEmpty()) {
            return;
        }
        tokens.poll();
        this.processConditions(tokens, this.getCondition());
    }

    private void processUpdatedColumns(Queue<String> tokens, List<ColumnInfo> updatedColumns, int targetColCount) throws SQLException {
        tokens.poll();
        if (!ParserUtil.isStringLiteral(tokens.peek())) {
            throw new SQLException("Syntax Error : String literal is expected");
        }
        ColumnInfo updatedColumn = new ColumnInfo(tokens.poll(), targetColCount);
        tokens.poll();
        tokens.poll();
        tokens.poll();
        updatedColumn.setValue(this.extractColumnValue(tokens));
        updatedColumns.add(updatedColumn);
        if (!tokens.isEmpty() && !"WHERE".equalsIgnoreCase(tokens.peek())) {
            this.processUpdatedColumns(tokens, updatedColumns, targetColCount + 1);
        }
    }

    private String extractColumnValue(Queue<String> tokens) throws SQLException {
        StringBuilder value = new StringBuilder();
        if ("?".equalsIgnoreCase(tokens.peek()) || ParserUtil.isStringLiteral(tokens.peek())) {
            value.append(tokens.poll());
        } else if ("'".equalsIgnoreCase(tokens.peek())) {
            while (!"'".equals(tokens.peek())) {
                value.append(tokens.poll());
            }
            tokens.poll();
        }
        return value.toString();
    }

    public DataTable getTargetTable() {
        return this.targetTable;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public ColumnInfo[] getTargetColumns() {
        return this.targetColumns;
    }
}

