/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.wso2.carbon.dataservices.sql.driver.TConnection;
import org.wso2.carbon.dataservices.sql.driver.TDriverUtil;
import org.wso2.carbon.dataservices.sql.driver.TPreparedStatement;

public class TExcelConnection
extends TConnection {
    private static final Log log = LogFactory.getLog(TExcelConnection.class);
    private Workbook workbook;
    private final int LOCK_TIMEOUT = 20;
    private static final Lock lock = new ReentrantLock();
    private static int lockCount = 0;
    private String filePath;

    public TExcelConnection(Properties props) throws SQLException {
        super(props);
        this.filePath = (String)props.get("filePath");
        this.workbook = this.createConnectionToExcelDocument(this.filePath);
    }

    private Workbook createConnectionToExcelDocument(String filePath) throws SQLException {
        Workbook workbook;
        try {
            this.acquireLock();
            InputStream fin = TDriverUtil.getInputStreamFromPath(filePath);
            workbook = WorkbookFactory.create((InputStream)fin);
        }
        catch (FileNotFoundException e) {
            throw new SQLException("Could not locate the EXCEL datasource in the provided location", e);
        }
        catch (IOException | InvalidFormatException e) {
            throw new SQLException("Error occurred while initializing the EXCEL datasource", e);
        }
        catch (InterruptedException e) {
            throw new SQLException("Error Acquiring the lock for the workbook path - " + filePath, e);
        }
        finally {
            this.releaseLock();
        }
        return workbook;
    }

    private synchronized void acquireLock() throws InterruptedException, SQLException {
        if (lock.tryLock(20L, TimeUnit.SECONDS)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Acquired the lock for the excel file to make it transactional, current lock count - " + ++lockCount));
            }
        } else {
            throw new SQLException("Error acquiring lock for the excel file even after 20 second wait, filePath - " + this.filePath);
        }
    }

    private synchronized void releaseLock() {
        block5: {
            try {
                lock.unlock();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Released the lock for excel file after the transaction, current lock count - " + --lockCount));
                }
            }
            catch (IllegalMonitorStateException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed to release the lock as it is already released, lock count - " + lockCount), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("Failed to release the lock as it is already released, lock count - " + lockCount), (Throwable)e);
            }
        }
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Statement createStatement(String sql) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new TPreparedStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("CallableStatements are not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("CallableStatements are not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("CallableStatements are not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new TPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    public void beginExcelTransaction() throws SQLException {
        this.workbook = this.createConnectionToExcelDocument(this.filePath);
    }

    @Override
    public void commit() throws SQLException {
        this.releaseLock();
    }

    @Override
    public void rollback() throws SQLException {
        this.releaseLock();
    }

    @Override
    public void close() throws SQLException {
        this.releaseLock();
    }
}

