/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.processor.reader;

import java.sql.Connection;
import java.sql.SQLException;
import org.wso2.carbon.dataservices.sql.driver.TConnection;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.CustomDataReader;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataReader;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.ExcelDataReader;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.GSpreadDataReader;

public class DataReaderFactory {
    public static DataReader createDataReader(Connection connection) throws SQLException {
        if (!(connection instanceof TConnection)) {
            throw new SQLException("Connection cannot be casted to 'TConnection'");
        }
        String connectionType = ((TConnection)connection).getType();
        if ("EXCEL".equals(connectionType)) {
            return new ExcelDataReader(connection);
        }
        if ("GSPREAD".equals(connectionType)) {
            return new GSpreadDataReader(connection);
        }
        if ("CUSTOM".equals(connectionType)) {
            return new CustomDataReader(connection);
        }
        throw new SQLException("Unsupported config type");
    }
}

