/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.sql.driver.processor.reader;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.wso2.carbon.dataservices.sql.driver.TConnection;
import org.wso2.carbon.dataservices.sql.driver.TExcelConnection;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.AbstractFixedDataReader;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataCell;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataRow;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.DataTable;
import org.wso2.carbon.dataservices.sql.driver.processor.reader.FixedDataTable;
import org.wso2.carbon.dataservices.sql.driver.query.ColumnInfo;

public class ExcelDataReader
extends AbstractFixedDataReader {
    public ExcelDataReader(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public void populateData() throws SQLException {
        Workbook workbook = ((TExcelConnection)this.getConnection()).getWorkbook();
        int noOfSheets = workbook.getNumberOfSheets();
        for (int i = 0; i < noOfSheets; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            ColumnInfo[] headers = this.extractColumnHeaders(sheet);
            FixedDataTable dataTable = new FixedDataTable(sheetName, headers);
            Iterator rowItr = sheet.rowIterator();
            while (rowItr.hasNext()) {
                Row row = (Row)rowItr.next();
                if (row.getRowNum() == 0) continue;
                DataRow dataRow = new DataRow(row.getRowNum() - 1);
                Iterator cellItr = row.cellIterator();
                int cellIndex = 0;
                while (cellItr.hasNext()) {
                    Cell cell = (Cell)cellItr.next();
                    DataCell dataCell = new DataCell(cellIndex + 1, cell.getCellType(), this.extractCellValue(cell));
                    dataRow.addCell(dataCell.getColumnId(), dataCell);
                    ++cellIndex;
                }
                ((DataTable)dataTable).addRow(dataRow);
            }
            this.getData().put(dataTable.getTableName(), dataTable);
        }
    }

    private Object extractCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case 0: {
                return cell.getNumericCellValue();
            }
            case 1: 
            case 2: 
            case 3: {
                return cell.getStringCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
        }
        return cell.getStringCellValue();
    }

    private ColumnInfo[] extractColumnHeaders(Sheet sheet) throws SQLException {
        ArrayList<ColumnInfo> headers = new ArrayList<ColumnInfo>();
        if (!((TConnection)this.getConnection()).hasHeader()) {
            int maxColumns = ((TConnection)this.getConnection()).getMaxColumns();
            for (int i = 0; i < maxColumns; ++i) {
                headers.add(new ColumnInfo(i + 1, "COLUMN" + (i + 1), sheet.getSheetName(), -1, i + 1));
            }
            return headers.toArray(new ColumnInfo[headers.size()]);
        }
        Row row = sheet.getRow(0);
        if (row != null) {
            Iterator itr = row.cellIterator();
            block5: while (itr.hasNext()) {
                Cell cell = (Cell)itr.next();
                if (cell == null) continue;
                int cellType = cell.getCellType();
                switch (cellType) {
                    case 1: {
                        headers.add(new ColumnInfo(cell.getColumnIndex() + 1, cell.getStringCellValue(), sheet.getSheetName(), 12, cell.getColumnIndex() + 1));
                        continue block5;
                    }
                    case 0: {
                        headers.add(new ColumnInfo(cell.getColumnIndex() + 1, String.valueOf(cell.getNumericCellValue()), sheet.getSheetName(), 4, cell.getColumnIndex() + 1));
                        continue block5;
                    }
                }
                throw new SQLException("Invalid column type");
            }
        }
        return headers.toArray(new ColumnInfo[headers.size()]);
    }
}

