/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.task.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.ntask.core.service.TaskService;

public class DSTaskServiceComponent {
    private static final Log log = LogFactory.getLog(DSTaskServiceComponent.class);
    private static TaskService taskService;

    protected void activate(ComponentContext ctxt) {
        try {
            DSTaskServiceComponent.getTaskService().registerTaskType("DATA_SERVICE_TASK");
            if (log.isDebugEnabled()) {
                log.debug((Object)"Data Services task bundle is activated ");
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"Data Services task bundle is deactivated ");
    }

    protected void setTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Task Service");
        }
        DSTaskServiceComponent.taskService = taskService;
    }

    protected void unsetTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Task Service");
        }
        DSTaskServiceComponent.taskService = null;
    }

    public static TaskService getTaskService() {
        return taskService;
    }
}

