/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.dataservices.core.description.operation.Operation;
import org.wso2.carbon.dataservices.core.engine.DataService;
import org.wso2.carbon.dataservices.task.DSTaskInfo;
import org.wso2.carbon.dataservices.task.DSTaskUtils;
import org.wso2.carbon.dataservices.task.internal.DSTaskServiceComponent;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class DSTaskAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(DSTaskAdmin.class);

    public String[] getAllTaskNames() throws AxisFault {
        try {
            TaskManager taskManager = DSTaskServiceComponent.getTaskService().getTaskManager("DATA_SERVICE_TASK");
            List taskInfoList = taskManager.getAllTasks();
            ArrayList<String> result = new ArrayList<String>();
            for (TaskInfo taskInfo : taskInfoList) {
                result.add(taskInfo.getName());
            }
            return result.toArray(new String[result.size()]);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault("Error in getting task names: " + e.getMessage(), (Throwable)e);
        }
    }

    public DSTaskInfo getTaskInfo(String taskName) throws AxisFault {
        try {
            TaskManager tm = DSTaskServiceComponent.getTaskService().getTaskManager("DATA_SERVICE_TASK");
            return DSTaskUtils.convert(tm.getTask(taskName));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault("Error getting task info for task: " + taskName, (Throwable)e);
        }
    }

    public void scheduleTask(DSTaskInfo dsTaskInfo) throws AxisFault {
        TaskManager tm = null;
        try {
            tm = DSTaskServiceComponent.getTaskService().getTaskManager("DATA_SERVICE_TASK");
            TaskInfo taskInfo = DSTaskUtils.convert(dsTaskInfo);
            tm.registerTask(taskInfo);
            tm.scheduleTask(taskInfo.getName());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            if (tm != null) {
                try {
                    tm.deleteTask(dsTaskInfo.getName());
                }
                catch (TaskException e1) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            throw new AxisFault("Error scheduling task: " + dsTaskInfo.getName(), (Throwable)e);
        }
    }

    public boolean rescheduleTask(DSTaskInfo dsTaskInfo) throws AxisFault {
        try {
            TaskManager tm = DSTaskServiceComponent.getTaskService().getTaskManager("DATA_SERVICE_TASK");
            TaskInfo taskInfo = DSTaskUtils.convert(dsTaskInfo);
            tm.registerTask(taskInfo);
            tm.rescheduleTask(taskInfo.getName());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault("Error rescheduling task: " + dsTaskInfo.getName() + " : " + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public void deleteTask(String taskName) throws AxisFault {
        try {
            TaskManager tm = DSTaskServiceComponent.getTaskService().getTaskManager("DATA_SERVICE_TASK");
            tm.deleteTask(taskName);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault("Error deleting task: " + taskName, (Throwable)e);
        }
    }

    public boolean isTaskScheduled(String taskName) throws AxisFault {
        try {
            TaskManager tm = DSTaskServiceComponent.getTaskService().getTaskManager("DATA_SERVICE_TASK");
            return tm.isTaskScheduled(taskName);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault("Error checking task scheduled status: " + taskName, (Throwable)e);
        }
    }

    public String[] getAllSchedulableDataServices() throws AxisFault {
        ArrayList<String> serviceList = new ArrayList<String>();
        HashMap serviceMap = this.getAxisConfig().getServices();
        for (String serviceName : serviceMap.keySet()) {
            AxisService axisService = this.getAxisConfig().getService(serviceName);
            Parameter serviceTypeParam = axisService.getParameter("serviceType");
            if (serviceTypeParam == null || !"data_service".equals(serviceTypeParam.getValue().toString()) || DSTaskUtils.extractHTTPEPR(axisService) == null) continue;
            serviceList.add(serviceName);
        }
        return serviceList.toArray(new String[serviceList.size()]);
    }

    public String[] getNoParamDSOperations(String dsName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getService(dsName);
        if (axisService == null) {
            return new String[0];
        }
        if (GhostDeployerUtils.isGhostService((AxisService)axisService)) {
            GhostDeployerUtils.deployActualService((AxisConfiguration)this.getAxisConfig(), (AxisService)axisService);
        }
        Parameter tmpParam = axisService.getParameter("org.wso2.ws.dataservice.dataservice.obj");
        ArrayList<String> result = new ArrayList<String>();
        if (tmpParam != null) {
            DataService ds = (DataService)tmpParam.getValue();
            for (String opName : ds.getOperationNames()) {
                Operation op = ds.getOperation(opName);
                if (op.getCallQuery().getWithParams().size() != 0 || this.isBoxcarringOp(opName)) continue;
                result.add(opName);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean isBoxcarringOp(String opName) {
        return "begin_boxcar".equals(opName) || "end_boxcar".equals(opName) || "abort_boxcar".equals(opName);
    }
}

