/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.task;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.dataservices.core.DBUtils;
import org.wso2.carbon.dataservices.task.DSTask;
import org.wso2.carbon.dataservices.task.DSTaskExt;
import org.wso2.carbon.dataservices.task.DSTaskInfo;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;

public class DSTaskUtils {
    public static DSTaskInfo convert(TaskInfo taskInfo) {
        DSTaskInfo dsTaskInfo = new DSTaskInfo();
        dsTaskInfo.setName(taskInfo.getName());
        Map taskProps = taskInfo.getProperties();
        dsTaskInfo.setDataTaskClassName((String)taskProps.get("DATA_TASK_CLASS_NAME"));
        dsTaskInfo.setServiceName((String)taskProps.get("DATA_SERVICE_NAME"));
        dsTaskInfo.setOperationName((String)taskProps.get("DATA_SERVICE_OPERATION_NAME"));
        TaskInfo.TriggerInfo triggerInfo = taskInfo.getTriggerInfo();
        dsTaskInfo.setCronExpression(triggerInfo.getCronExpression());
        dsTaskInfo.setStartTime(DSTaskUtils.dateToCal(triggerInfo.getStartTime()));
        dsTaskInfo.setEndTime(DSTaskUtils.dateToCal(triggerInfo.getEndTime()));
        dsTaskInfo.setTaskCount(triggerInfo.getRepeatCount());
        dsTaskInfo.setTaskInterval(triggerInfo.getIntervalMillis());
        return dsTaskInfo;
    }

    public static TaskInfo convert(DSTaskInfo dsTaskInfo) {
        TaskInfo.TriggerInfo triggerInfo = new TaskInfo.TriggerInfo();
        triggerInfo.setCronExpression(dsTaskInfo.getCronExpression());
        if (dsTaskInfo.getStartTime() != null) {
            triggerInfo.setStartTime(dsTaskInfo.getStartTime().getTime());
        }
        if (dsTaskInfo.getEndTime() != null) {
            triggerInfo.setEndTime(dsTaskInfo.getEndTime().getTime());
        }
        triggerInfo.setIntervalMillis(dsTaskInfo.getTaskInterval());
        triggerInfo.setRepeatCount(dsTaskInfo.getTaskCount());
        HashMap<String, String> props = new HashMap<String, String>();
        if (dsTaskInfo.getDataTaskClassName() != null) {
            props.put("DATA_TASK_CLASS_NAME", dsTaskInfo.getDataTaskClassName());
            props.put("DATA_SERVICE_TASK_NAME", dsTaskInfo.getName());
            triggerInfo.setDisallowConcurrentExecution(true);
            return new TaskInfo(dsTaskInfo.getName(), DSTaskExt.class.getName(), props, triggerInfo);
        }
        props.put("DATA_SERVICE_NAME", dsTaskInfo.getServiceName());
        props.put("DATA_SERVICE_OPERATION_NAME", dsTaskInfo.getOperationName());
        props.put("SERVICE_ACTION", "urn:" + dsTaskInfo.getOperationName());
        return new TaskInfo(dsTaskInfo.getName(), DSTask.class.getName(), props, triggerInfo);
    }

    private static Calendar dateToCal(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String extractHTTPEPR(AxisService axisService) {
        for (String epr : axisService.getEPRs()) {
            if (!epr.startsWith("http:")) continue;
            return epr;
        }
        return null;
    }

    public static boolean isInOutMEPInOperation(AxisService axisService, String opName) {
        AxisOperation operation;
        Parameter param = axisService.getParameter("org.wso2.ws.dataservice.dataservice.obj");
        return param != null && ("http://www.w3.org/ns/wsdl/in-out".equals((operation = axisService.getOperation(new QName(opName))).getMessageExchangePattern()) || "http://www.w3.org/ns/wsdl/out-only".equals(operation.getMessageExchangePattern()));
    }

    public static AxisConfiguration lookupAxisConfig(int tid) {
        AxisConfiguration tenantAxisConf;
        ConfigurationContext mainConfigCtx = TasksDSComponent.getConfigurationContextService().getServerConfigContext();
        if (tid == -1234) {
            tenantAxisConf = mainConfigCtx.getAxisConfiguration();
        } else {
            String tenantDomain = DBUtils.getTenantDomainFromId((int)tid);
            tenantAxisConf = TenantAxisUtils.getTenantAxisConfiguration((String)tenantDomain, (ConfigurationContext)mainConfigCtx);
        }
        return tenantAxisConf;
    }

    public static AxisService lookupAxisService(int tid, String serviceName) {
        return DSTaskUtils.lookupAxisService(DSTaskUtils.lookupAxisConfig(tid), serviceName);
    }

    public static AxisService lookupAxisService(AxisConfiguration tenantAxisConf, String serviceName) {
        try {
            if (tenantAxisConf != null) {
                return tenantAxisConf.getService(serviceName);
            }
            return null;
        }
        catch (AxisFault e) {
            return null;
        }
    }
}

