/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.task.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.ntask.core.service.TaskService;

@Component(name="dataservices.task", immediate=true)
public class DSTaskServiceComponent {
    private static final Log log = LogFactory.getLog(DSTaskServiceComponent.class);
    private static TaskService taskService;

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            DSTaskServiceComponent.getTaskService().registerTaskType("DATA_SERVICE_TASK");
            if (log.isDebugEnabled()) {
                log.debug((Object)"Data Services task bundle is activated ");
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"Data Services task bundle is deactivated ");
    }

    @Reference(name="ntask.component", service=TaskService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTaskService")
    protected void setTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Task Service");
        }
        DSTaskServiceComponent.taskService = taskService;
    }

    protected void unsetTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Task Service");
        }
        DSTaskServiceComponent.taskService = null;
    }

    public static TaskService getTaskService() {
        return taskService;
    }
}

