/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.task.ui;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.task.ui.stub.xsd.DSTaskInfo;

public class DSTaskManagementHelper {
    private static final Log log = LogFactory.getLog(DSTaskManagementHelper.class);

    public static DSTaskInfo createTaskInfo(HttpServletRequest request) throws ServletException, AxisFault {
        String taskClass;
        String scheduleType;
        String count;
        String interval;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating the task description corresponds to the task");
        }
        DSTaskInfo dsTaskInfo = new DSTaskInfo();
        String taskName = request.getParameter("taskName");
        if (taskName == null && "".equals(taskName) && (taskName = request.getParameter("taskName_hidden")) == null && "".equals(taskName)) {
            DSTaskManagementHelper.handleException("Task Name cannot be empty");
        }
        dsTaskInfo.setName(taskName.trim());
        String startTimeAsString = request.getParameter("startTime");
        if (startTimeAsString != null && !"".equals(startTimeAsString.trim())) {
            dsTaskInfo.setStartTime(DSTaskManagementHelper.getProcessedStartTime(startTimeAsString));
        }
        if ((interval = request.getParameter("triggerInterval")) != null && !"".equals(interval)) {
            try {
                dsTaskInfo.setTaskInterval(Integer.parseInt(interval.trim()));
            }
            catch (NumberFormatException e) {
                DSTaskManagementHelper.handleException("Invalid value for interval (Expected type is integer) : " + interval);
            }
        }
        if ((count = request.getParameter("triggerCount")) != null && !"".equals(count)) {
            try {
                dsTaskInfo.setTaskCount(Integer.parseInt(count.trim()));
            }
            catch (NumberFormatException e) {
                DSTaskManagementHelper.handleException("Invalid value for Count (Expected type is int) : " + count);
            }
        }
        String string = scheduleType = (scheduleType = request.getParameter("scheduleType")) == null ? "" : scheduleType;
        if (scheduleType.equals("DataService Operation")) {
            String dataServiceName;
            String cron = request.getParameter("triggerCron");
            if (cron != null && !"".equals(cron)) {
                dsTaskInfo.setCronExpression(cron.trim());
            }
            if ((dataServiceName = request.getParameter("dataServiceName")) == null || "".equals(dataServiceName)) {
                DSTaskManagementHelper.handleException("Service Name cannot be null");
            }
            dsTaskInfo.setServiceName(dataServiceName);
            String operationName = request.getParameter("operationName");
            if (operationName == null || "".equals(operationName)) {
                DSTaskManagementHelper.handleException("Operation name cannot be null");
            }
            dsTaskInfo.setOperationName(operationName);
        } else if (scheduleType.equals("DataService Task Class") && (taskClass = request.getParameter("dssTaskClass")) != null && !"".equals(taskClass)) {
            dsTaskInfo.setDataTaskClassName(taskClass.trim());
        }
        return dsTaskInfo;
    }

    private static void handleException(String msg) throws ServletException {
        log.error((Object)msg);
        throw new ServletException(msg);
    }

    private static Calendar getProcessedStartTime(String startTimeAsString) throws AxisFault {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        try {
            Date startTime = df.parse(startTimeAsString);
            Calendar cal = Calendar.getInstance();
            cal.setTime(startTime);
            return cal;
        }
        catch (ParseException e) {
            throw new AxisFault("Invalid DateTime format", (Throwable)e);
        }
    }

    public static String formatStartTime(Calendar startTime) throws AxisFault {
        if (startTime == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return df.format(startTime.getTime());
    }
}

