/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.ui.beans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.ui.beans.Attribute;
import org.wso2.carbon.dataservices.ui.beans.CallQuery;
import org.wso2.carbon.dataservices.ui.beans.CallQueryGroup;
import org.wso2.carbon.dataservices.ui.beans.Element;
import org.wso2.carbon.dataservices.ui.beans.RDFResource;

public class ComplexElement {
    private List<Element> elements;
    private List<Attribute> attributes;
    private List<CallQueryGroup> callQueryGroups;
    private List<ComplexElement> complexElements;
    private List<RDFResource> resources;
    private String name;
    private String namespace;
    private String arrayName;

    public ComplexElement(String name, String namespace, String arrayName) {
        this.name = name;
        this.namespace = namespace;
        this.arrayName = arrayName;
        this.elements = new ArrayList<Element>();
        this.attributes = new ArrayList<Attribute>();
        this.callQueryGroups = new ArrayList<CallQueryGroup>();
        this.complexElements = new ArrayList<ComplexElement>();
        this.resources = new ArrayList<RDFResource>();
    }

    public ComplexElement() {
        this.elements = new ArrayList<Element>();
        this.attributes = new ArrayList<Attribute>();
        this.callQueryGroups = new ArrayList<CallQueryGroup>();
        this.complexElements = new ArrayList<ComplexElement>();
        this.resources = new ArrayList<RDFResource>();
    }

    public void addCallQuery(CallQuery callQuery) {
        CallQueryGroup callQueryGroup = new CallQueryGroup();
        callQueryGroup.addCallQuery(callQuery);
        this.addCallQueryGroup(callQueryGroup);
    }

    public void addCallQueryGroup(CallQueryGroup callQueryGroup) {
        this.getCallQueryGroups().add(callQueryGroup);
    }

    public List<CallQueryGroup> getCallQueryGroups() {
        return this.callQueryGroups;
    }

    public void addComplexElement(ComplexElement complexElement) {
        this.getComplexElements().add(complexElement);
    }

    public List<ComplexElement> getComplexElements() {
        return this.complexElements;
    }

    public void addElement(Element element) {
        this.getElements().add(element);
    }

    public void addResource(RDFResource resource) {
        this.getResources().add(resource);
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public void addAttribute(Attribute attribute) {
        this.getAttributes().add(attribute);
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public List<RDFResource> getResources() {
        return this.resources;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getArrayName() {
        return this.arrayName;
    }

    public void setArrayName(String arrayName) {
        this.arrayName = arrayName;
    }

    public Element removeElement(String elementName) {
        Element element = new Element();
        for (int a = 0; a < this.elements.size(); ++a) {
            element = this.elements.get(a);
            if (!element.getName().equals(elementName)) continue;
            element = this.elements.remove(a);
        }
        return element;
    }

    public Attribute removeAttribute(String attributeName) {
        Attribute attribute = new Attribute();
        for (int a = 0; a < this.attributes.size(); ++a) {
            attribute = this.attributes.get(a);
            if (!attribute.getName().equals(attributeName)) continue;
            attribute = this.attributes.remove(a);
        }
        return attribute;
    }

    public ComplexElement removeComplexElement(String elementName) {
        ComplexElement element = new ComplexElement();
        ComplexElement removingELement = null;
        for (int a = 0; a < this.complexElements.size(); ++a) {
            element = this.complexElements.get(a);
            if (!element.getName().equals(elementName)) continue;
            removingELement = this.complexElements.remove(a);
        }
        return removingELement;
    }

    public void removeCallQuery(String href) {
        CallQuery callQuery = null;
        CallQueryGroup callQueryGroup = null;
        Iterator<CallQueryGroup> callQueryGroupsItr = this.getCallQueryGroups().iterator();
        while (callQueryGroupsItr.hasNext()) {
            callQueryGroup = callQueryGroupsItr.next();
            if (callQueryGroup.getCallQueries().size() != 1 || !(callQuery = callQueryGroup.getCallQueries().get(0)).getHref().equals(href)) continue;
            callQueryGroupsItr.remove();
            break;
        }
    }

    public List<CallQuery> getCallQueries() {
        ArrayList<CallQuery> list = new ArrayList<CallQuery>();
        for (CallQueryGroup callQueryGroup : this.getCallQueryGroups()) {
            if (callQueryGroup.getCallQueries().size() != 1) continue;
            list.add(callQueryGroup.getCallQueries().get(0));
        }
        return list;
    }

    public ComplexElement getComplexElement(String name) {
        ComplexElement retrievElement = new ComplexElement();
        ComplexElement complexElement = new ComplexElement();
        for (int a = 0; a < this.complexElements.size(); ++a) {
            complexElement = this.complexElements.get(a);
            if (complexElement == null || !complexElement.getName().equals(name)) continue;
            retrievElement = complexElement;
        }
        return retrievElement;
    }

    public OMElement buildXML() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement elementEl = fac.createOMElement("element", null);
        if (this.getName() != null) {
            elementEl.addAttribute("name", this.getName(), null);
        }
        if (this.getNamespace() != null) {
            elementEl.addAttribute("namespace", this.getNamespace(), null);
        }
        if (this.getArrayName() != null) {
            elementEl.addAttribute("arrayName", this.getArrayName(), null);
        }
        for (Element element : this.getElements()) {
            elementEl.addChild((OMNode)element.buildXML());
        }
        for (RDFResource resource : this.getResources()) {
            elementEl.addChild((OMNode)resource.buildXML());
        }
        for (Attribute attribute : this.getAttributes()) {
            elementEl.addChild((OMNode)attribute.buildXML());
        }
        for (CallQueryGroup callQueryGroup : this.getCallQueryGroups()) {
            elementEl.addChild((OMNode)callQueryGroup.buildXML());
        }
        for (ComplexElement complexElement : this.getComplexElements()) {
            elementEl.addChild((OMNode)complexElement.buildXML());
        }
        return elementEl;
    }
}

