/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.ui.beans;

import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.common.conf.DynamicAuthConfiguration;
import org.wso2.carbon.dataservices.ui.beans.DataServiceConfigurationElement;

public class Property
extends DataServiceConfigurationElement {
    private String name;
    private Object value;
    private boolean useSecretAlias;

    public Property() {
    }

    public Property(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isUseSecretAlias() {
        return this.useSecretAlias;
    }

    public void setUseSecretAlias(boolean useSecretAlias) {
        this.useSecretAlias = useSecretAlias;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OMElement buildXML() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement propEl = fac.createOMElement("property", null);
        if (this.getValue() == null) return propEl;
        if (this.getValue() instanceof ArrayList) {
            propEl.addAttribute("name", this.getName(), null);
            for (Property p : (List)this.getValue()) {
                OMElement propNestedEl = fac.createOMElement("property", null);
                propNestedEl.addAttribute("name", p.getName(), null);
                if (p.isUseSecretAlias()) {
                    propNestedEl.addAttribute("svns:secretAlias", (String)p.getValue(), null);
                } else {
                    propNestedEl.setText((String)p.getValue());
                }
                propEl.addChild((OMNode)propNestedEl);
            }
            return propEl;
        } else if (this.getValue() instanceof String) {
            if (((String)this.getValue()).trim().length() == 0) return null;
            propEl.addAttribute("name", this.getName(), null);
            propEl.setText((String)this.getValue());
            return propEl;
        } else {
            if (!(this.getValue() instanceof DynamicAuthConfiguration)) return propEl;
            propEl.addAttribute("name", this.getName(), null);
            OMElement dynamicUserAuthConfigEle = fac.createOMElement("configuration", null);
            DynamicAuthConfiguration dynamicAuthConfiguration = (DynamicAuthConfiguration)this.getValue();
            List dynamicUserEntries = dynamicAuthConfiguration.getEntries();
            if (dynamicUserEntries == null) return propEl;
            for (DynamicAuthConfiguration.Entry userEntry : dynamicUserEntries) {
                OMElement dynamicUserEntryEle = fac.createOMElement("entry", null);
                dynamicUserEntryEle.addAttribute("request", userEntry.getRequest(), null);
                OMElement userEle = fac.createOMElement("username", null);
                userEle.setText(userEntry.getUsername());
                OMElement pwdEle = fac.createOMElement("password", null);
                pwdEle.setText(userEntry.getPassword());
                dynamicUserEntryEle.addChild((OMNode)userEle);
                dynamicUserEntryEle.addChild((OMNode)pwdEle);
                dynamicUserAuthConfigEle.addChild((OMNode)dynamicUserEntryEle);
            }
            propEl.addChild((OMNode)dynamicUserAuthConfigEle);
        }
        return propEl;
    }
}

