/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.ui.beans;

import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.ui.beans.DataServiceConfigurationElement;

public class Validator
extends DataServiceConfigurationElement {
    private String elementName;
    private String name;
    private Map<String, String> validatorElements = new HashMap<String, String>();
    private Map<String, String> customProperties = new HashMap<String, String>();

    public Validator(String elementName, Map<String, String> validatorElements, Map<String, String> customProperties) {
        this.elementName = elementName;
        if (this.elementName.equals("validateLongRange")) {
            this.name = "Long Range Validator";
        } else if (this.elementName.equals("validateDoubleRange")) {
            this.name = "Double Range Validator";
        } else if (this.elementName.equals("validateLength")) {
            this.name = "Length Validator";
        } else if (this.elementName.equals("validatePattern")) {
            this.name = "Pattern Validator";
        } else if (this.elementName.equals("validateCustom")) {
            this.name = "Custom Validator";
        }
        this.validatorElements = validatorElements;
        this.customProperties = customProperties;
    }

    public String getName() {
        return this.name;
    }

    public String getElementName() {
        return this.elementName;
    }

    public Map<String, String> getValidatorElements() {
        return this.validatorElements;
    }

    public void setValidatorElements(Map<String, String> validatorElements) {
        this.validatorElements = validatorElements;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    @Override
    public OMElement buildXML() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement valEl = fac.createOMElement(this.getElementName(), null);
        for (Map.Entry<String, String> entry : this.getValidatorElements().entrySet()) {
            valEl.addAttribute(entry.getKey(), entry.getValue(), null);
            if (this.customProperties.size() <= 0) continue;
            OMElement propEl = fac.createOMElement("properties", null);
            for (Map.Entry<String, String> propEntry : this.customProperties.entrySet()) {
                OMElement propNestedEl = fac.createOMElement("property", null);
                propNestedEl.addAttribute("name", propEntry.getKey(), null);
                propNestedEl.setText(propEntry.getValue());
                propEl.addChild((OMNode)propNestedEl);
            }
            valEl.addChild((OMNode)propEl);
        }
        return valEl;
    }

    public String getPropertiesString() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        int n = this.getValidatorElements().size();
        for (Map.Entry<String, String> entry : this.getValidatorElements().entrySet()) {
            builder.append(entry.getKey() + "=" + entry.getValue());
            if (i + 1 < n) {
                builder.append(" ");
            }
            ++i;
        }
        return builder.toString();
    }
}

