/*
 * Copyright 2005,2006 WSO2, Inc. http://www.wso2.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wso2.carbon.dataservices.ui.beans;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

/*
Represents rdf-ref-uri elements for rdf result section.
   <element name="productLine" rdf-ref-uri="http://productLines.com/{productLine}" />  
*/

public class RDFResource extends DataServiceConfigurationElement{
    private String rdfRefURI;
    private String name;

    public void setName(String name){
        this.name = name;
    }

    public String getName(){
        return name;
    }

    public String getRdfRefURI(){
        return rdfRefURI;
    }

    public void setRdfRefURI(String rdfRefURI){
        this.rdfRefURI = rdfRefURI;
    }
    
    public RDFResource(String rdfRefURI, String name, String requiredRoles, String xsdType){
        super(requiredRoles,xsdType);
        this.rdfRefURI = rdfRefURI;
        this.name = name;
    }

    public RDFResource(){
        
    }

    public OMElement buildXML() {
    	OMFactory fac = OMAbstractFactory.getOMFactory();
    	OMElement attrEl = fac.createOMElement("element", null);
    	if (this.getName() != null) {
    	    attrEl.addAttribute("name", this.getName(), null);
    	}
    	if (this.getRdfRefURI() != null) {
    	    attrEl.addAttribute("rdf-ref-uri", this.getRdfRefURI(), null);
    	}
    	if (this.getRequiredRoles() != null) {
            attrEl.addAttribute("requiredRoles", this.getRequiredRoles(), null);
        }        
        if (this.getXsdType() != null) {
            attrEl.addAttribute("xsdType", this.getXsdType(), null);
        }
    	return attrEl;
    }
}
