/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.ui.beans;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.common.RDBMSUtils;
import org.wso2.carbon.dataservices.ui.beans.DataServiceConfigurationElement;
import org.wso2.carbon.dataservices.ui.beans.Property;

public class Config
extends DataServiceConfigurationElement {
    private String id;
    private ArrayList<Property> properties = new ArrayList();
    private String dataSourceType;
    private boolean useSecretAliasForPassword;
    private boolean exposeAsODataService;

    public ArrayList<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<Property> properties) {
        this.properties = new ArrayList();
        for (Property prop : properties) {
            this.addProperty(prop);
        }
    }

    public void addProperty(Property property) {
        if (RDBMSUtils.configPropContainsInV2((String)property.getName())) {
            String newPropName = RDBMSUtils.convertConfigPropFromV2toV3((String)property.getName());
            if (newPropName != null) {
                this.addProperty(newPropName, property.getValue());
            }
        } else {
            this.addProperty(property.getName(), property.getValue());
        }
    }

    public void addProperty(String name, Object value) {
        Property property = new Property(name, value);
        this.properties.add(property);
        this.setDatasourceType(name);
    }

    public void removeProperty(Property propertyName) {
        this.properties.remove(propertyName);
    }

    public void removeProperty(String propertyName) {
        Property property = new Property();
        for (int a = 0; a < this.properties.size(); ++a) {
            property = this.properties.get(a);
            if (!property.getName().equals(propertyName)) continue;
            this.removeProperty(property);
        }
    }

    private void setDatasourceType(String propertyName) {
        if ("driverClassName".equals(propertyName) || "dataSourceClassName".equals(propertyName)) {
            this.dataSourceType = "RDBMS";
        } else if ("csv_datasource".equals(propertyName)) {
            this.dataSourceType = "CSV";
        } else if ("excel_datasource".equals(propertyName)) {
            this.dataSourceType = "EXCEL";
        } else if ("cassandraServers".equals(propertyName)) {
            this.dataSourceType = "Cassandra";
        } else if ("rdf_datasource".equals(propertyName)) {
            this.dataSourceType = "RDF";
        } else if ("sparql_datasource".equals(propertyName)) {
            this.dataSourceType = "SPARQL";
        } else if ("mongoDB_servers".equals(propertyName)) {
            this.dataSourceType = "MongoDB";
        } else if ("jndi_provider_url".equals(propertyName) || "jndi_resource_name".equals(propertyName)) {
            this.dataSourceType = "JNDI";
        } else if ("gspread_datasource".equals(propertyName)) {
            this.dataSourceType = "GDATA_SPREADSHEET";
        } else if ("carbon_datasource_name".equals(propertyName)) {
            this.dataSourceType = "CARBON_DATASOURCE";
        } else if ("web_harvest_config".equals(propertyName)) {
            this.dataSourceType = "WEB_CONFIG";
        } else if ("custom_query_datasource_class".equals(propertyName) || "custom_tabular_datasource_class".equals(propertyName)) {
            this.dataSourceType = "CUSTOM";
        }
    }

    public void updateProperty(String name, Object value) {
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            if (value != null) {
                property.setValue(value);
            } else {
                property.setValue("");
            }
            this.setDatasourceType(name);
        }
    }

    public void updatePropertyName(String name, String value) {
        Iterator<Property> propertyItr = this.properties.iterator();
        Property property = propertyItr.next();
        if (!property.getName().equals(name)) {
            this.properties.remove(property);
            Property newProperty = new Property(name, (Object)value);
            this.properties.add(newProperty);
        }
        this.setDatasourceType(name);
    }

    public Object getPropertyValue(String propertyName) {
        for (Property property : this.properties) {
            if (!property.getName().equals(propertyName)) continue;
            return property.getValue();
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isExposeAsODataService() {
        return this.exposeAsODataService;
    }

    public void setExposeAsOData(boolean value) {
        this.exposeAsODataService = value;
    }

    public boolean isUseSecretAliasForPassword() {
        return this.useSecretAliasForPassword;
    }

    public void setUseSecretAliasForPassword(boolean useSecretAliasForPassword) {
        this.useSecretAliasForPassword = useSecretAliasForPassword;
    }

    public String getDataSourceType() {
        return this.dataSourceType;
    }

    @Override
    public OMElement buildXML() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement confEl = fac.createOMElement("config", null);
        if (this.getId() != null) {
            confEl.addAttribute("id", this.getId(), null);
            confEl.addAttribute("enableOData", String.valueOf(this.exposeAsODataService), null);
        }
        for (Property property : this.getProperties()) {
            if (this.isUseSecretAliasForPassword() && (property.getName().equals("password") || property.getName().equals("org.wso2.ws.dataservice.password") || property.getName().equals("gspread_password") || property.getName().equals("jndi_password"))) {
                OMFactory factory = OMAbstractFactory.getOMFactory();
                OMElement propEl = factory.createOMElement("property", null);
                propEl.addAttribute("name", property.getName(), null);
                propEl.addAttribute("svns:secretAlias", (String)property.getValue(), null);
                confEl.addChild((OMNode)propEl);
                continue;
            }
            if (property.buildXML() == null) continue;
            confEl.addChild((OMNode)property.buildXML());
        }
        return confEl;
    }
}

