/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.ui.beans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.dataservices.common.conf.DynamicAuthConfiguration;
import org.wso2.carbon.dataservices.ui.beans.Attribute;
import org.wso2.carbon.dataservices.ui.beans.AuthProvider;
import org.wso2.carbon.dataservices.ui.beans.CallQuery;
import org.wso2.carbon.dataservices.ui.beans.CallQueryGroup;
import org.wso2.carbon.dataservices.ui.beans.ComplexElement;
import org.wso2.carbon.dataservices.ui.beans.Config;
import org.wso2.carbon.dataservices.ui.beans.DataServiceConfigurationElement;
import org.wso2.carbon.dataservices.ui.beans.Element;
import org.wso2.carbon.dataservices.ui.beans.Event;
import org.wso2.carbon.dataservices.ui.beans.ExcelQuery;
import org.wso2.carbon.dataservices.ui.beans.GSpreadQuery;
import org.wso2.carbon.dataservices.ui.beans.Operation;
import org.wso2.carbon.dataservices.ui.beans.Param;
import org.wso2.carbon.dataservices.ui.beans.Property;
import org.wso2.carbon.dataservices.ui.beans.Query;
import org.wso2.carbon.dataservices.ui.beans.RDFResource;
import org.wso2.carbon.dataservices.ui.beans.Resource;
import org.wso2.carbon.dataservices.ui.beans.Result;
import org.wso2.carbon.dataservices.ui.beans.SQLDialect;
import org.wso2.carbon.dataservices.ui.beans.Validator;
import org.wso2.carbon.dataservices.ui.beans.WithParam;
import org.wso2.carbon.dataservices.ui.beans.XADataSource;

public class Data
extends DataServiceConfigurationElement {
    private String name;
    private String description;
    private String serviceNamespace;
    private boolean batchRequest;
    private boolean boxcarring;
    private boolean disableLegacyBoxcarringMode;
    private boolean enableXA;
    private boolean isUseAppServerTS;
    private boolean enableHTTP;
    private boolean enableHTTPS;
    private boolean enableLocal;
    private boolean enableJMS;
    private String txManagerJNDIName;
    private String txManagerClass;
    private String txManagerCleanupMethod;
    private boolean disableStreaming;
    private String protectedTokens;
    private String passwordProvider;
    private ArrayList<Config> configs = new ArrayList();
    private ArrayList<Operation> operations;
    private ArrayList<Query> queries = new ArrayList();
    private ArrayList<Resource> resources;
    private ArrayList<Event> events;
    private ArrayList<XADataSource> xADataSources;
    private boolean useColumnNumbers;
    private boolean escapeNonPrintableChar;
    private String serviceHierarchy;
    private String status;
    private String secureVaultNamespace;
    private AuthProvider authProvider;

    public Data() {
        this.operations = new ArrayList();
        this.resources = new ArrayList();
        this.events = new ArrayList();
        this.xADataSources = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServiceHierarchy() {
        return this.serviceHierarchy;
    }

    public void setServiceHierarchy(String serviceHierarchy) {
        this.serviceHierarchy = serviceHierarchy;
    }

    public String getServiceNamespace() {
        return this.serviceNamespace;
    }

    public void setServiceNamespace(String serviceNamespace) {
        this.serviceNamespace = serviceNamespace;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTxManagerName() {
        return this.txManagerJNDIName;
    }

    public void setTxManagerName(String txManagerName) {
        this.txManagerJNDIName = txManagerName;
    }

    public String getTxManagerClass() {
        return this.txManagerClass;
    }

    public void setTxManagerClass(String txManagerClass) {
        this.txManagerClass = txManagerClass;
    }

    public boolean isEnableXA() {
        return this.enableXA;
    }

    public void setEnableXA(boolean enableXA) {
        this.enableXA = enableXA;
    }

    public boolean isUseAppServerTS() {
        return this.isUseAppServerTS;
    }

    public void setIsUseAppServerTS(boolean isUseAppServerTS) {
        this.isUseAppServerTS = isUseAppServerTS;
    }

    public ArrayList<XADataSource> getXADataSources() {
        return this.xADataSources;
    }

    public void setxADataSources(ArrayList<XADataSource> xADataSources) {
        this.xADataSources = xADataSources;
    }

    public boolean isBatchRequest() {
        return this.batchRequest;
    }

    public void setBatchRequest(boolean batchRequest) {
        this.batchRequest = batchRequest;
    }

    public boolean isBoxcarring() {
        return this.boxcarring;
    }

    public void setBoxcarring(boolean boxcarring) {
        this.boxcarring = boxcarring;
    }

    public boolean isDisableLegacyBoxcarringMode() {
        return this.disableLegacyBoxcarringMode;
    }

    public void setDisableLegacyBoxcarringMode(boolean disableLegacyBoxcarringMode) {
        this.disableLegacyBoxcarringMode = disableLegacyBoxcarringMode;
    }

    public boolean isEnableHTTP() {
        return this.enableHTTP;
    }

    public void setEnableHTTP(boolean enableHTTP) {
        this.enableHTTP = enableHTTP;
    }

    public boolean isEnableHTTPS() {
        return this.enableHTTPS;
    }

    public void setEnableHTTPS(boolean enableHTTPS) {
        this.enableHTTPS = enableHTTPS;
    }

    public boolean isEnableLocal() {
        return this.enableLocal;
    }

    public void setEnableLocal(boolean enableLocal) {
        this.enableLocal = enableLocal;
    }

    public boolean isEnableJMS() {
        return this.enableJMS;
    }

    public void setEnableJMS(boolean enableJMS) {
        this.enableJMS = enableJMS;
    }

    public boolean isUseColumnNumbers() {
        return this.useColumnNumbers;
    }

    public void setUseColumnNumbers(boolean useColumnNumbers) {
        this.useColumnNumbers = useColumnNumbers;
    }

    public boolean isEscapeNonPrintableChar() {
        return this.escapeNonPrintableChar;
    }

    public void setEscapeNonPrintableChar(boolean escapeNonPrintableChar) {
        this.escapeNonPrintableChar = escapeNonPrintableChar;
    }

    public ArrayList<Config> getConfigs() {
        return this.configs;
    }

    public void setConfig(Config config) {
        this.configs.add(config);
    }

    public void removeConfig(Config config) {
        this.configs.remove(config);
    }

    public ArrayList<Operation> getOperations() {
        return this.operations;
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    public void removeOperation(Operation operation) {
        this.operations.remove(operation);
    }

    public void addXADataSource(XADataSource xADataSource) {
        this.xADataSources.add(xADataSource);
    }

    public void removeXADataSource(XADataSource xADataSource) {
        this.xADataSources.remove(xADataSource);
    }

    public ArrayList<Event> getEvents() {
        return this.events;
    }

    public void addEvent(Event event) {
        this.events.add(event);
    }

    public void removeEvent(Event event) {
        this.events.remove(event);
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public void removeResource(Resource resource) {
        this.resources.remove(resource);
    }

    public ArrayList<Query> getQueries() {
        return this.queries;
    }

    public void addQuery(Query query) {
        this.queries.add(query);
    }

    public void removeQuery(Query query) {
        this.queries.remove(query);
    }

    public ArrayList<Resource> getResources() {
        return this.resources;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getProtectedTokens() {
        return this.protectedTokens;
    }

    public void setProtectedTokens(String protectedTokens) {
        this.protectedTokens = protectedTokens;
    }

    public String getPasswordProvider() {
        return this.passwordProvider;
    }

    public void setPasswordProvider(String passwordProvider) {
        this.passwordProvider = passwordProvider;
    }

    public String getTxManagerCleanupMethod() {
        return this.txManagerCleanupMethod;
    }

    public void setTxManagerCleanupMethod(String txManagerCleanupMethod) {
        this.txManagerCleanupMethod = txManagerCleanupMethod;
    }

    public boolean isDisableStreaming() {
        return this.disableStreaming;
    }

    public void setDisableStreaming(boolean disableStreaming) {
        this.disableStreaming = disableStreaming;
    }

    public String getSecureVaultNamespace() {
        return this.secureVaultNamespace;
    }

    public void setSecureVaultNamespace(String secureVaultNamespace) {
        this.secureVaultNamespace = secureVaultNamespace;
    }

    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    public void validate() {
    }

    public Config getConfig(String configId) {
        for (Config config : this.configs) {
            if (!config.getId().equals(configId)) continue;
            return config;
        }
        return null;
    }

    private Config getConfig(OMElement configEle) {
        OMAttribute enableOdataAttribute;
        Config config = new Config();
        OMAttribute id = configEle.getAttribute(new QName("id"));
        if (id != null) {
            config.setId(id.getAttributeValue());
        }
        if ((enableOdataAttribute = configEle.getAttribute(new QName("enableOData"))) != null) {
            config.setExposeAsOData(Boolean.parseBoolean(enableOdataAttribute.getAttributeValue()));
        }
        Iterator properties = configEle.getChildrenWithName(new QName("property"));
        while (properties.hasNext()) {
            OMElement propertyEle = (OMElement)properties.next();
            Property property = new Property();
            OMAttribute name = propertyEle.getAttribute(new QName("name"));
            if (name != null) {
                OMAttribute propertyName;
                OMAttribute secretAlias;
                OMElement nestedPropertyEle;
                Property nestedProp;
                ArrayList<Property> nestedProperty;
                Iterator nestedProperties;
                if (name.getAttributeValue().equals("dataSourceProps")) {
                    property.setName(name.getAttributeValue());
                    nestedProperties = propertyEle.getChildrenWithName(new QName("property"));
                    nestedProperty = new ArrayList<Property>();
                    while (nestedProperties.hasNext()) {
                        nestedProp = new Property();
                        nestedPropertyEle = (OMElement)nestedProperties.next();
                        secretAlias = nestedPropertyEle.getAttribute(new QName("http://org.wso2.securevault/configuration", "secretAlias"));
                        propertyName = nestedPropertyEle.getAttribute(new QName("name"));
                        nestedProp.setName(propertyName.getAttributeValue());
                        if (secretAlias != null) {
                            nestedProp.setUseSecretAlias(true);
                            nestedProp.setValue(secretAlias.getAttributeValue());
                        } else {
                            nestedProp.setValue(nestedPropertyEle.getText());
                        }
                        nestedProperty.add(nestedProp);
                    }
                    property.setValue(nestedProperty);
                } else if (name.getAttributeValue().equals("dynamicUserAuthMapping")) {
                    property.setName(name.getAttributeValue());
                    ArrayList<DynamicAuthConfiguration.Entry> dynamicUserList = new ArrayList<DynamicAuthConfiguration.Entry>();
                    DynamicAuthConfiguration dynamicAuthConfiguration = new DynamicAuthConfiguration();
                    Iterator dynamicUserAuthConfigs = propertyEle.getChildrenWithName(new QName("configuration"));
                    while (dynamicUserAuthConfigs.hasNext()) {
                        OMElement dynamicUserConfig = (OMElement)dynamicUserAuthConfigs.next();
                        Iterator userEntries = dynamicUserConfig.getChildrenWithName(new QName("entry"));
                        while (userEntries.hasNext()) {
                            OMElement userEntry = (OMElement)userEntries.next();
                            DynamicAuthConfiguration.Entry dynamicUserEntry = new DynamicAuthConfiguration.Entry();
                            String carbonUsername = userEntry.getAttributeValue(new QName("request"));
                            String dbUsername = userEntry.getFirstChildWithName(new QName("username")).getText();
                            String dbUserPwd = userEntry.getFirstChildWithName(new QName("password")).getText();
                            dynamicUserEntry.setRequest(carbonUsername);
                            dynamicUserEntry.setUsername(dbUsername);
                            dynamicUserEntry.setPassword(dbUserPwd);
                            dynamicUserList.add(dynamicUserEntry);
                        }
                    }
                    dynamicAuthConfiguration.setEntries(dynamicUserList);
                    property.setValue(dynamicAuthConfiguration);
                } else if (name.getAttributeValue().equals("custom_datasource_props")) {
                    property.setName(name.getAttributeValue());
                    nestedProperties = propertyEle.getChildrenWithName(new QName("property"));
                    nestedProperty = new ArrayList();
                    while (nestedProperties.hasNext()) {
                        nestedProp = new Property();
                        nestedPropertyEle = (OMElement)nestedProperties.next();
                        secretAlias = nestedPropertyEle.getAttribute(new QName("http://org.wso2.securevault/configuration", "secretAlias"));
                        propertyName = nestedPropertyEle.getAttribute(new QName("name"));
                        nestedProp.setName(propertyName.getAttributeValue());
                        if (secretAlias != null) {
                            nestedProp.setUseSecretAlias(true);
                            nestedProp.setValue(secretAlias.getAttributeValue());
                        } else {
                            nestedProp.setValue(nestedPropertyEle.getText());
                        }
                        nestedProperty.add(nestedProp);
                    }
                    property.setValue(nestedProperty);
                } else {
                    property.setName(name.getAttributeValue());
                    if (name.getAttributeValue().equals("password") || name.getAttributeValue().equals("jndi_password") || name.getAttributeValue().equals("org.wso2.ws.dataservice.password") || name.getAttributeValue().equals("gspread_password")) {
                        OMAttribute secretAlias2 = propertyEle.getAttribute(new QName("http://org.wso2.securevault/configuration", "secretAlias"));
                        if (secretAlias2 != null) {
                            config.setUseSecretAliasForPassword(true);
                            property.setValue(secretAlias2.getAttributeValue());
                        } else {
                            property.setValue(propertyEle.getText());
                        }
                    } else {
                        property.setValue(propertyEle.getText());
                    }
                }
            }
            config.addProperty(property);
        }
        return config;
    }

    private void setCommonQueryProps(OMElement queryEle, Query query) {
        Iterator results;
        query.setId(queryEle.getAttributeValue(new QName("id")));
        query.setConfigToUse(queryEle.getAttributeValue(new QName("useConfig")));
        query.setInputEventTrigger(queryEle.getAttributeValue(new QName("input-event-trigger")));
        query.setOutputEventTrigger(queryEle.getAttributeValue(new QName("output-event-trigger")));
        query.setReturnGeneratedKeys(Boolean.parseBoolean(queryEle.getAttributeValue(new QName("returnGeneratedKeys"))));
        query.setReturnUpdatedRowCount(Boolean.parseBoolean(queryEle.getAttributeValue(new QName("returnUpdatedRowCount"))));
        query.setKeyColumns(queryEle.getAttributeValue(new QName("keyColumns")));
        Param[] params = this.getParams(queryEle.getChildrenWithName(new QName("param")));
        query.setParams(params);
        OMElement propEl = queryEle.getFirstChildWithName(new QName("properties"));
        if (propEl != null) {
            Iterator properties = propEl.getChildrenWithName(new QName("property"));
            while (properties.hasNext()) {
                OMElement propertyEle = (OMElement)properties.next();
                Property property = new Property();
                OMAttribute name = propertyEle.getAttribute(new QName("name"));
                if (name != null) {
                    property.setName(name.getAttributeValue());
                    property.setValue(propertyEle.getText());
                }
                query.addProperty(property);
            }
        }
        if ((results = queryEle.getChildrenWithName(new QName("result"))).hasNext()) {
            OMElement resultEle = (OMElement)results.next();
            query.setResult(this.getResult(resultEle));
        }
    }

    private Query getSQLQuery(OMElement queryEle) {
        Query query = new Query();
        ArrayList<SQLDialect> sqlDialects = new ArrayList<SQLDialect>();
        this.setCommonQueryProps(queryEle, query);
        Iterator itr = queryEle.getChildrenWithName(new QName("sql"));
        String sql = null;
        while (itr.hasNext()) {
            OMElement sqlQuery = (OMElement)itr.next();
            if (sqlQuery.getAttributeValue(new QName("dialect")) != null) {
                String dialect = sqlQuery.getAttributeValue(new QName("dialect"));
                String dialectQuery = sqlQuery.getText();
                sqlDialects.add(new SQLDialect(dialect, dialectQuery));
            }
            if (sqlQuery.getAttributeValue(new QName("dialect")) != null) continue;
            sql = sqlQuery.getText();
        }
        query.setSqlDialects(sqlDialects);
        if (sql != null) {
            query.setSql(sql);
        }
        return query;
    }

    private Query getExpQuery(OMElement queryEle) {
        Query query = new Query();
        this.setCommonQueryProps(queryEle, query);
        Iterator itr = queryEle.getChildrenWithName(new QName("expression"));
        String sql = null;
        while (itr.hasNext()) {
            OMElement sqlQuery = (OMElement)itr.next();
            if (sqlQuery.getAttributeValue(new QName("dialect")) != null) continue;
            sql = sqlQuery.getText();
        }
        if (sql != null) {
            query.setExpression(sql);
        }
        return query;
    }

    private Query getSparqlQuery(OMElement queryEle) {
        Query query = new Query();
        this.setCommonQueryProps(queryEle, query);
        OMElement sparqlEle = queryEle.getFirstChildWithName(new QName("sparql"));
        query.setSparql(sparqlEle.getText());
        return query;
    }

    private Query getScraperVariable(OMElement queryEle) {
        Query query = new Query();
        this.setCommonQueryProps(queryEle, query);
        OMElement scraperEle = queryEle.getFirstChildWithName(new QName("scraperVariable"));
        query.setScraperVariable(scraperEle.getText());
        return query;
    }

    private Query getExcelQuery(OMElement queryEle) {
        Query query = new Query();
        this.setCommonQueryProps(queryEle, query);
        OMElement excelEle = queryEle.getFirstChildWithName(new QName("excel"));
        ExcelQuery excelQuery = new ExcelQuery();
        OMElement workBookName = excelEle.getFirstChildWithName(new QName("workbookname"));
        excelQuery.setWorkBookName(workBookName.getText());
        OMElement hasHeader = excelEle.getFirstChildWithName(new QName("hasheader"));
        excelQuery.setHasHeaders(hasHeader.getText());
        OMElement startingRow = excelEle.getFirstChildWithName(new QName("startingrow"));
        excelQuery.setStartingRow(startingRow.getText());
        OMElement maxRowCount = excelEle.getFirstChildWithName(new QName("maxrowcount"));
        excelQuery.setMaxRowCount(maxRowCount.getText());
        OMElement headerRow = excelEle.getFirstChildWithName(new QName("headerrow"));
        if (headerRow != null) {
            excelQuery.setHeaderRow(headerRow.getText());
        }
        query.setExcel(excelQuery);
        return query;
    }

    private Query getGSpreadQuery(OMElement queryEle) {
        Query query = new Query();
        this.setCommonQueryProps(queryEle, query);
        OMElement gspreadEl = queryEle.getFirstChildWithName(new QName("gspread"));
        GSpreadQuery gspreadQuery = new GSpreadQuery();
        OMElement workSheetNumber = gspreadEl.getFirstChildWithName(new QName("worksheetnumber"));
        gspreadQuery.setWorkSheetNumber(Integer.parseInt(workSheetNumber.getText()));
        OMElement startingRow = gspreadEl.getFirstChildWithName(new QName("startingrow"));
        gspreadQuery.setStartingRow(Integer.parseInt(startingRow.getText()));
        OMElement maxRowCount = gspreadEl.getFirstChildWithName(new QName("maxrowcount"));
        gspreadQuery.setMaxRowCount(Integer.parseInt(maxRowCount.getText()));
        OMElement hasHeaders = gspreadEl.getFirstChildWithName(new QName("hasheader"));
        gspreadQuery.setHasHeaders(hasHeaders.getText());
        OMElement headerRow = gspreadEl.getFirstChildWithName(new QName("headerrow"));
        if (headerRow != null) {
            gspreadQuery.setHeaderRow(Integer.parseInt(headerRow.getText()));
        }
        query.setGSpread(gspreadQuery);
        return query;
    }

    private void addAttributeToComplexEl(ComplexElement complexEl, OMElement attributeEle) {
        String name = attributeEle.getAttribute(new QName("name")).getAttributeValue();
        OMAttribute columnAttr = attributeEle.getAttribute(new QName("column"));
        OMAttribute queryParamattr = attributeEle.getAttribute(new QName("query-param"));
        OMAttribute arrayNameAttr = attributeEle.getAttribute(new QName("arrayName"));
        String column = null;
        String queryParam = null;
        String arrayName = null;
        if (columnAttr != null) {
            column = columnAttr.getAttributeValue();
        }
        if (queryParamattr != null) {
            queryParam = queryParamattr.getAttributeValue();
        }
        if (arrayNameAttr != null) {
            arrayName = arrayNameAttr.getAttributeValue();
        }
        OMAttribute requiredRolesAttr = attributeEle.getAttribute(new QName("requiredRoles"));
        String requiredRoles = null;
        if (requiredRolesAttr != null) {
            requiredRoles = requiredRolesAttr.getAttributeValue();
        }
        OMAttribute xsdTypeAttr = attributeEle.getAttribute(new QName("xsdType"));
        String xsdType = null;
        if (xsdTypeAttr != null) {
            xsdType = xsdTypeAttr.getAttributeValue();
        }
        OMAttribute optionalattr = attributeEle.getAttribute(new QName("optional"));
        String optional = null;
        if (optionalattr != null) {
            optional = optionalattr.getAttributeValue();
        }
        OMAttribute exportattr = attributeEle.getAttribute(new QName("export"));
        String export = null;
        if (exportattr != null) {
            export = exportattr.getAttributeValue();
        }
        OMAttribute exportTypeattr = attributeEle.getAttribute(new QName("exportType"));
        String exportType = null;
        if (exportTypeattr != null) {
            exportType = exportTypeattr.getAttributeValue();
        }
        if (column != null) {
            Attribute attribute = new Attribute("column", column, name, requiredRoles, xsdType, export, exportType, arrayName, optional);
            complexEl.addAttribute(attribute);
        } else if (queryParam != null) {
            Attribute attribute = new Attribute("query-param", queryParam, name, requiredRoles, xsdType, export, exportType, arrayName, optional);
            complexEl.addAttribute(attribute);
        }
    }

    private void addElementToComplexEl(ComplexElement complexEl, OMElement elementEle) {
        OMAttribute nameattr = elementEle.getAttribute(new QName("name"));
        String name = null;
        if (nameattr != null) {
            name = nameattr.getAttributeValue();
        }
        OMAttribute columnattr = elementEle.getAttribute(new QName("column"));
        OMAttribute queryParamattr = elementEle.getAttribute(new QName("query-param"));
        String column = null;
        String queryParam = null;
        if (columnattr != null) {
            column = columnattr.getAttributeValue();
        }
        if (queryParamattr != null) {
            queryParam = queryParamattr.getAttributeValue();
        }
        OMAttribute resourcenattr = elementEle.getAttribute(new QName("rdf-ref-uri"));
        String resource = null;
        if (resourcenattr != null) {
            resource = resourcenattr.getAttributeValue();
        }
        OMAttribute requiredRolesattr = elementEle.getAttribute(new QName("requiredRoles"));
        String requiredRoles = null;
        if (requiredRolesattr != null) {
            requiredRoles = requiredRolesattr.getAttributeValue();
        }
        OMAttribute xsdTypeattr = elementEle.getAttribute(new QName("xsdType"));
        String xsdType = null;
        if (xsdTypeattr != null) {
            xsdType = xsdTypeattr.getAttributeValue();
        }
        OMAttribute optionalattr = elementEle.getAttribute(new QName("optional"));
        String optional = null;
        if (optionalattr != null) {
            optional = optionalattr.getAttributeValue();
        }
        OMAttribute exportattr = elementEle.getAttribute(new QName("export"));
        String export = null;
        if (exportattr != null) {
            export = exportattr.getAttributeValue();
        }
        OMAttribute exportTypeattr = elementEle.getAttribute(new QName("exportType"));
        String exportType = null;
        if (exportTypeattr != null) {
            exportType = exportTypeattr.getAttributeValue();
        }
        OMAttribute namespaceAttr = elementEle.getAttribute(new QName("namespace"));
        String namespace = null;
        if (namespaceAttr != null) {
            namespace = namespaceAttr.getAttributeValue();
        }
        OMAttribute arrayNameAttr = elementEle.getAttribute(new QName("arrayName"));
        String arrayName = null;
        if (arrayNameAttr != null) {
            arrayName = arrayNameAttr.getAttributeValue();
        }
        if (column != null) {
            Element element = new Element("column", column, name, requiredRoles, xsdType, export, exportType, namespace, arrayName, optional);
            complexEl.addElement(element);
        } else if (queryParam != null) {
            Element element = new Element("query-param", queryParam, name, requiredRoles, xsdType, export, exportType, namespace, arrayName, optional);
            complexEl.addElement(element);
        } else {
            RDFResource rdfResource = new RDFResource(resource, name, requiredRoles, xsdType);
            complexEl.addResource(rdfResource);
        }
    }

    private boolean isComplexElement(OMElement el) {
        return el.getChildElements().hasNext();
    }

    public ComplexElement getComplexElement(OMElement complexElementEl) {
        ComplexElement complexEl = new ComplexElement();
        OMAttribute nameAttrib = complexElementEl.getAttribute(new QName("name"));
        OMAttribute namespaceAttrib = complexElementEl.getAttribute(new QName("namespace"));
        OMAttribute arrayNameAttrib = complexElementEl.getAttribute(new QName("arrayName"));
        if (nameAttrib != null) {
            complexEl.setName(nameAttrib.getAttributeValue());
        }
        if (namespaceAttrib != null) {
            complexEl.setNamespace(namespaceAttrib.getAttributeValue());
        }
        if (arrayNameAttrib != null) {
            complexEl.setArrayName(arrayNameAttrib.getAttributeValue());
        }
        Iterator itrElements = complexElementEl.getChildrenWithName(new QName("element"));
        while (itrElements.hasNext()) {
            OMElement elementEle = (OMElement)itrElements.next();
            if (this.isComplexElement(elementEle)) {
                complexEl.getComplexElements().add(this.getComplexElement(elementEle));
                continue;
            }
            this.addElementToComplexEl(complexEl, elementEle);
        }
        Iterator itrAttributes = complexElementEl.getChildrenWithName(new QName("attribute"));
        while (itrAttributes.hasNext()) {
            OMElement attributeEle = (OMElement)itrAttributes.next();
            this.addAttributeToComplexEl(complexEl, attributeEle);
        }
        Iterator itrCallQueries = complexElementEl.getChildrenWithName(new QName("call-query"));
        while (itrCallQueries.hasNext()) {
            OMElement callQueryEle = (OMElement)itrCallQueries.next();
            CallQueryGroup callQueryGroup = this.getCallQueryGroup(callQueryEle);
            complexEl.addCallQueryGroup(callQueryGroup);
        }
        Iterator itrCallQueryGroups = complexElementEl.getChildrenWithName(new QName("call-query-group"));
        while (itrCallQueryGroups.hasNext()) {
            OMElement callQueryEle = (OMElement)itrCallQueryGroups.next();
            CallQueryGroup callQueryGroup = this.getCallQueryGroup(callQueryEle);
            complexEl.addCallQueryGroup(callQueryGroup);
        }
        return complexEl;
    }

    public Result getResult(OMElement resultEle) {
        try {
            OMAttribute outputTypeAttrib = resultEle.getAttribute(new QName("outputType"));
            OMAttribute wrapperAttrib = resultEle.getAttribute(new QName("element"));
            OMAttribute rowNameAttrib = resultEle.getAttribute(new QName("rowName"));
            OMAttribute namespaceAttrib = resultEle.getAttribute(new QName("defaultNamespace"));
            OMAttribute rdfBaseURIAttrib = resultEle.getAttribute(new QName("rdfBaseURI"));
            OMAttribute xsltPathAttrib = resultEle.getAttribute(new QName("xsltPath"));
            OMAttribute useColumnNoAttrib = resultEle.getAttribute(new QName("useColumnNumbers"));
            OMAttribute escapeNonPrintableCharAttrib = resultEle.getAttribute(new QName("escapeNonPrintableChar"));
            Result result = new Result();
            result.setTextMapping(resultEle.getText());
            if (outputTypeAttrib != null) {
                result.setOutputType(outputTypeAttrib.getAttributeValue());
            }
            if (wrapperAttrib != null) {
                result.setResultWrapper(wrapperAttrib.getAttributeValue());
            }
            if (rowNameAttrib != null) {
                result.setRowName(rowNameAttrib.getAttributeValue());
            }
            if (rdfBaseURIAttrib != null) {
                result.setRdfBaseURI(rdfBaseURIAttrib.getAttributeValue());
            }
            if (namespaceAttrib != null) {
                result.setNamespace(namespaceAttrib.getAttributeValue());
            }
            if (xsltPathAttrib != null) {
                result.setXsltPath(xsltPathAttrib.getAttributeValue());
            }
            if (useColumnNoAttrib != null) {
                result.setUseColumnNumbers(useColumnNoAttrib.getAttributeValue());
            }
            if (escapeNonPrintableCharAttrib != null) {
                result.setEscapeNonPrintableChar(escapeNonPrintableCharAttrib.getAttributeValue());
            }
            ComplexElement resultComplexEl = this.getComplexElement(resultEle);
            result.setElements(resultComplexEl.getElements());
            result.setResources(resultComplexEl.getResources());
            result.setAttributes(resultComplexEl.getAttributes());
            result.setCallQueryGroups(resultComplexEl.getCallQueryGroups());
            result.setComplexElements(resultComplexEl.getComplexElements());
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Query getQuery(OMElement queryEle) {
        OMElement sqlEle = queryEle.getFirstChildWithName(new QName("sql"));
        OMElement expEle = queryEle.getFirstChildWithName(new QName("expression"));
        OMElement sparqlEle = queryEle.getFirstChildWithName(new QName("sparql"));
        OMElement excelEle = queryEle.getFirstChildWithName(new QName("excel"));
        OMElement gspreadEl = queryEle.getFirstChildWithName(new QName("gspread"));
        OMElement scraperEle = queryEle.getFirstChildWithName(new QName("scraperVariable"));
        Query query = null;
        if (sqlEle != null) {
            query = this.getSQLQuery(queryEle);
        } else if (sparqlEle != null) {
            query = this.getSparqlQuery(queryEle);
        } else if (excelEle != null) {
            query = this.getExcelQuery(queryEle);
        } else if (gspreadEl != null) {
            query = this.getGSpreadQuery(queryEle);
        } else if (scraperEle != null) {
            query = this.getScraperVariable(queryEle);
        } else if (expEle != null) {
            query = this.getExpQuery(queryEle);
        } else {
            query = new Query();
            this.setCommonQueryProps(queryEle, query);
        }
        return query;
    }

    private Operation getOperation(OMElement operationEle) {
        OMElement descriptionEle;
        String returnRequestStatus;
        OMElement callQueryEle = operationEle.getFirstChildWithName(new QName("call-query"));
        if (callQueryEle == null) {
            callQueryEle = operationEle.getFirstChildWithName(new QName("call-query-group"));
        }
        Operation operation = new Operation();
        operation.setName(operationEle.getAttributeValue(new QName("name")));
        String disableStreaming = operationEle.getAttributeValue(new QName("disableStreaming"));
        if (disableStreaming != null) {
            operation.setDisableStreaming(Boolean.parseBoolean(disableStreaming));
        }
        if ((returnRequestStatus = operationEle.getAttributeValue(new QName("returnRequestStatus"))) != null) {
            operation.setReturnRequestStatus(Boolean.parseBoolean(returnRequestStatus));
        }
        if ((descriptionEle = operationEle.getFirstChildWithName(new QName("description"))) != null) {
            operation.setDescription(descriptionEle.getText());
        }
        CallQueryGroup callQueryGroup = this.getCallQueryGroup(callQueryEle);
        operation.setCallQueryGroup(callQueryGroup);
        return operation;
    }

    private Event getEvent(OMElement eventEle) {
        Event event = new Event();
        event.setId(eventEle.getAttributeValue(new QName("id")));
        event.setLanguage(eventEle.getAttributeValue(new QName("language")));
        event.setExpression(eventEle.getFirstChildWithName(new QName("expression")).getText());
        event.setTargetTopic(eventEle.getFirstChildWithName(new QName("target-topic")).getText());
        OMElement subsEl = eventEle.getFirstChildWithName(new QName("subscriptions"));
        if (subsEl != null) {
            Iterator subscripts = subsEl.getChildrenWithName(new QName("subscription"));
            while (subscripts.hasNext()) {
                OMElement sub = (OMElement)subscripts.next();
                event.addSubscription(sub.getText());
            }
        }
        return event;
    }

    private XADataSource getXADataSource(OMElement xaDataSourceEle) {
        XADataSource xaDataSource = new XADataSource();
        xaDataSource.setId(xaDataSourceEle.getAttributeValue(new QName("id")));
        xaDataSource.setClassName(xaDataSourceEle.getAttributeValue(new QName("class")));
        Iterator properties = xaDataSourceEle.getChildrenWithName(new QName("property"));
        while (properties.hasNext()) {
            OMElement propertyEle = (OMElement)properties.next();
            Property property = new Property();
            OMAttribute name = propertyEle.getAttribute(new QName("name"));
            if (name != null) {
                property.setName(name.getAttributeValue());
                property.setValue(propertyEle.getText());
            }
            xaDataSource.addProperty(property);
        }
        return xaDataSource;
    }

    private Resource getResource(OMElement resourceEle) {
        OMElement descriptionEle;
        String returnRequestStatus;
        OMElement callQueryEle = resourceEle.getFirstChildWithName(new QName("call-query"));
        Resource resource = new Resource();
        resource.setMethod(resourceEle.getAttributeValue(new QName("method")));
        resource.setPath(resourceEle.getAttributeValue(new QName("path")));
        String disableStreaming = resourceEle.getAttributeValue(new QName("disableStreaming"));
        if (disableStreaming != null) {
            resource.setDisableStreaming(Boolean.parseBoolean(disableStreaming));
        }
        if ((returnRequestStatus = resourceEle.getAttributeValue(new QName("returnRequestStatus"))) != null) {
            resource.setReturnRequestStatus(Boolean.parseBoolean(returnRequestStatus));
        }
        if ((descriptionEle = resourceEle.getFirstChildWithName(new QName("description"))) != null) {
            resource.setDescription(descriptionEle.getText());
        }
        CallQueryGroup callQueryGroup = this.getCallQueryGroup(callQueryEle);
        resource.setCallQueryGroup(callQueryGroup);
        return resource;
    }

    private AuthProvider getAuthorizationProvider(OMElement authProviderEl) {
        AuthProvider authProvider = null;
        OMAttribute authProviderClassAtt = authProviderEl.getAttribute(new QName("class"));
        if (authProviderClassAtt != null) {
            authProvider = new AuthProvider();
            authProvider.setClassName(authProviderClassAtt.getAttributeValue());
            Iterator properties = authProviderEl.getChildrenWithName(new QName("property"));
            while (properties.hasNext()) {
                OMElement propertyEle = (OMElement)properties.next();
                Property property = new Property();
                OMAttribute name = propertyEle.getAttribute(new QName("name"));
                if (name != null) {
                    property.setName(name.getAttributeValue());
                    property.setValue(propertyEle.getText());
                }
                authProvider.addProperty(property);
            }
        }
        return authProvider;
    }

    public void populate(OMElement dsXml) {
        OMElement authorizationProviderConfigEl;
        Iterator pwdMngrElements;
        OMNamespace secureVaultNamespace;
        OMAttribute transportsConfig;
        OMAttribute serviceStatus;
        OMAttribute disableStreaming;
        OMAttribute disableLegacyBoxcarringMode;
        OMAttribute enableBoxcarring;
        OMAttribute enableBatchReq;
        OMElement desc;
        OMAttribute serviceName = dsXml.getAttribute(new QName("name"));
        if (serviceName != null) {
            this.setName(serviceName.getAttributeValue());
        }
        if ((desc = dsXml.getFirstChildWithName(new QName("description"))) != null) {
            this.setDescription(desc.getText());
        }
        if ((enableBatchReq = dsXml.getAttribute(new QName("enableBatchRequests"))) != null) {
            this.setBatchRequest(Boolean.parseBoolean(enableBatchReq.getAttributeValue()));
        }
        if ((enableBoxcarring = dsXml.getAttribute(new QName("enableBoxcarring"))) != null) {
            this.setBoxcarring(Boolean.parseBoolean(enableBoxcarring.getAttributeValue()));
        }
        if ((disableLegacyBoxcarringMode = dsXml.getAttribute(new QName("disableLegacyBoxcarringMode"))) != null) {
            this.setDisableLegacyBoxcarringMode(Boolean.parseBoolean(disableLegacyBoxcarringMode.getAttributeValue()));
        }
        if ((disableStreaming = dsXml.getAttribute(new QName("disableStreaming"))) != null) {
            this.setDisableStreaming(Boolean.parseBoolean(disableStreaming.getAttributeValue()));
        }
        Iterator txElements = dsXml.getChildrenWithName(new QName("transactionManagement"));
        while (txElements.hasNext()) {
            OMElement txManagerCleanupMethodEle;
            OMElement enableXAEle;
            OMElement useAppServerTSEle;
            OMElement txManagerClassEle;
            OMElement txEle = (OMElement)txElements.next();
            OMElement txManagerNameEle = txEle.getFirstChildWithName(new QName("txManagerName"));
            if (txManagerNameEle != null) {
                this.setTxManagerName(txManagerNameEle.getText());
            }
            if ((txManagerClassEle = txEle.getFirstChildWithName(new QName("txManagerClass"))) != null) {
                this.setTxManagerClass(txManagerClassEle.getText());
            }
            if ((useAppServerTSEle = txEle.getFirstChildWithName(new QName("useAppServerTS"))) != null) {
                this.setIsUseAppServerTS(Boolean.parseBoolean(useAppServerTSEle.getText()));
            }
            if ((enableXAEle = txEle.getFirstChildWithName(new QName("enableXA"))) != null) {
                this.setEnableXA(Boolean.parseBoolean(enableXAEle.getText()));
            }
            if ((txManagerCleanupMethodEle = txEle.getFirstChildWithName(new QName("txManagerCleanupMethod"))) == null) continue;
            this.setTxManagerCleanupMethod(txManagerCleanupMethodEle.getText());
        }
        OMAttribute serviceNamespaceAttr = dsXml.getAttribute(new QName("serviceNamespace"));
        if (serviceNamespaceAttr != null) {
            this.setServiceNamespace(serviceNamespaceAttr.getAttributeValue());
        }
        if ((serviceStatus = dsXml.getAttribute(new QName("serviceStatus"))) != null) {
            this.setStatus(serviceStatus.getAttributeValue());
        }
        if ((transportsConfig = dsXml.getAttribute(new QName("transports"))) != null) {
            String allTransportStr = transportsConfig.getAttributeValue();
            List<String> transportList = Arrays.asList(allTransportStr.split(" "));
            this.setEnableHTTP(transportList.contains("http"));
            this.setEnableHTTPS(transportList.contains("https"));
            this.setEnableLocal(transportList.contains("local"));
            this.setEnableJMS(transportList.contains("jms"));
        }
        if ((secureVaultNamespace = dsXml.findNamespaceURI("svns")) != null) {
            this.setSecureVaultNamespace(secureVaultNamespace.getNamespaceURI());
        }
        if ((pwdMngrElements = dsXml.getChildrenWithName(new QName("passwordManager"))).hasNext()) {
            OMElement pwdManagerElement = (OMElement)pwdMngrElements.next();
            OMElement protectedTokenEle = pwdManagerElement.getFirstChildWithName(new QName("protectedTokens"));
            this.setProtectedTokens(protectedTokenEle.getText());
            OMElement passwordProviderEle = pwdManagerElement.getFirstChildWithName(new QName("passwordProvider"));
            this.setPasswordProvider(passwordProviderEle.getText());
        }
        if ((authorizationProviderConfigEl = dsXml.getFirstChildWithName(new QName("authorization_provider"))) != null) {
            this.setAuthProvider(this.getAuthorizationProvider(authorizationProviderConfigEl));
        }
        Iterator configElements = dsXml.getChildrenWithName(new QName("config"));
        this.configs = new ArrayList();
        while (configElements.hasNext()) {
            OMElement configEle = (OMElement)configElements.next();
            this.configs.add(this.getConfig(configEle));
        }
        Iterator queryElements = dsXml.getChildrenWithName(new QName("query"));
        this.queries = new ArrayList();
        while (queryElements.hasNext()) {
            OMElement queryEle = (OMElement)queryElements.next();
            this.queries.add(this.getQuery(queryEle));
        }
        Iterator events = dsXml.getChildrenWithName(new QName("event-trigger"));
        this.events = new ArrayList();
        while (events.hasNext()) {
            OMElement eventsEle = (OMElement)events.next();
            this.events.add(this.getEvent(eventsEle));
        }
        Iterator xADataSource = dsXml.getChildrenWithName(new QName("xa-datasource"));
        this.xADataSources = new ArrayList();
        while (xADataSource.hasNext()) {
            OMElement xADataSourcesEle = (OMElement)xADataSource.next();
            this.xADataSources.add(this.getXADataSource(xADataSourcesEle));
        }
        Iterator operationElements = dsXml.getChildrenWithName(new QName("operation"));
        this.operations = new ArrayList();
        while (operationElements.hasNext()) {
            OMElement operationEle = (OMElement)operationElements.next();
            this.operations.add(this.getOperation(operationEle));
        }
        Iterator resourcesElements = dsXml.getChildrenWithName(new QName("resource"));
        this.resources = new ArrayList();
        while (resourcesElements.hasNext()) {
            OMElement resourceEle = (OMElement)resourcesElements.next();
            this.resources.add(this.getResource(resourceEle));
        }
    }

    private CallQueryGroup getCallQueryGroup(OMElement cqEl) {
        CallQueryGroup callQueryGroup = new CallQueryGroup();
        if (cqEl.getLocalName().equals("call-query-group")) {
            OMAttribute requiredRolesattr = cqEl.getAttribute(new QName("requiredRoles"));
            String requiredRoles = null;
            if (requiredRolesattr != null) {
                requiredRoles = requiredRolesattr.getAttributeValue();
            }
            callQueryGroup.setRequiredRoles(requiredRoles);
            Iterator callQueryItr = cqEl.getChildrenWithName(new QName("call-query"));
            OMElement tmpEl = null;
            while (callQueryItr.hasNext()) {
                tmpEl = (OMElement)callQueryItr.next();
                callQueryGroup.addCallQuery(this.getCallQuery(tmpEl));
            }
        } else {
            callQueryGroup.addCallQuery(this.getCallQuery(cqEl));
        }
        return callQueryGroup;
    }

    private CallQuery getCallQuery(OMElement callQueryEle) {
        String href = callQueryEle.getAttributeValue(new QName("href"));
        CallQuery callQuery = new CallQuery();
        callQuery.setHref(href);
        OMAttribute requiredRolesattr = callQueryEle.getAttribute(new QName("requiredRoles"));
        String requiredRoles = null;
        if (requiredRolesattr != null) {
            requiredRoles = requiredRolesattr.getAttributeValue();
        }
        callQuery.setRequiredRoles(requiredRoles);
        Iterator itrWithParamsEles = callQueryEle.getChildrenWithName(new QName("with-param"));
        while (itrWithParamsEles.hasNext()) {
            OMElement withParamEle = (OMElement)itrWithParamsEles.next();
            String name = withParamEle.getAttributeValue(new QName("name"));
            String queryParam = withParamEle.getAttributeValue(new QName("query-param"));
            String columnParam = withParamEle.getAttributeValue(new QName("column"));
            WithParam withParam = new WithParam();
            withParam.setName(name);
            if (columnParam != null) {
                withParam.setParamValue(columnParam);
                withParam.setParamType("column");
            } else {
                withParam.setParamValue(queryParam);
                withParam.setParamType("query-param");
            }
            callQuery.addWithParam(withParam);
        }
        return callQuery;
    }

    public Operation getOperation(String operationName) {
        for (Operation operation : this.getOperations()) {
            if (!operation.getName().equals(operationName)) continue;
            return operation;
        }
        return null;
    }

    public XADataSource getXADataSource(String xADataSourceId) {
        for (XADataSource xADataSource : this.getXADataSources()) {
            if (xADataSource.getId() == null || !xADataSource.getId().equals(xADataSourceId)) continue;
            return xADataSource;
        }
        return null;
    }

    public Event getEvent(String eventName) {
        for (Event event : this.getEvents()) {
            if (!event.getId().equals(eventName)) continue;
            return event;
        }
        return null;
    }

    public Resource getResource(String resourcePath, String resourceMethod) {
        for (Resource resource : this.getResources()) {
            if (!resource.getPath().equals(resourcePath) || !resource.getMethod().equals(resourceMethod)) continue;
            return resource;
        }
        return null;
    }

    public Param[] getParams(Iterator<OMElement> paramItr) {
        ArrayList<Param> paramList = new ArrayList<Param>();
        int ordinal = 0;
        while (paramItr.hasNext()) {
            OMElement paramElement = paramItr.next();
            String userSetOrdinalValue = paramElement.getAttributeValue(new QName("ordinal"));
            if (userSetOrdinalValue == null || userSetOrdinalValue.trim().length() == 0) {
                userSetOrdinalValue = String.valueOf(ordinal);
            }
            Param param = new Param(paramElement.getAttributeValue(new QName("name")), paramElement.getAttributeValue(new QName("paramType")), paramElement.getAttributeValue(new QName("sqlType")), paramElement.getAttributeValue(new QName("type")), userSetOrdinalValue, paramElement.getAttributeValue(new QName("defaultValue")), paramElement.getAttributeValue(new QName("structType")), this.getValidators(paramElement.getChildElements()));
            paramList.add(param);
        }
        Param[] params = new Param[paramList.size()];
        paramList.toArray(params);
        return params;
    }

    private List<Validator> getValidators(Iterator<OMElement> valItr) {
        ArrayList<Validator> vals = new ArrayList<Validator>();
        while (valItr.hasNext()) {
            OMElement valEl = valItr.next();
            String valElementName = valEl.getLocalName();
            Iterator attrItr = valEl.getAllAttributes();
            HashMap<String, String> propMap = new HashMap<String, String>();
            while (attrItr.hasNext()) {
                OMAttribute attr = (OMAttribute)attrItr.next();
                propMap.put(attr.getLocalName(), attr.getAttributeValue());
            }
            Map<String, String> customPropMap = this.extractAdvancedProps(valEl);
            vals.add(new Validator(valElementName, propMap, customPropMap));
        }
        return vals;
    }

    public Query getQuery(String queryId) {
        for (Query query : this.queries) {
            if (!query.getId().equals(queryId)) continue;
            return query;
        }
        return null;
    }

    @Override
    public OMElement buildXML() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement dataEl = fac.createOMElement("data", null);
        if (this.getName() != null) {
            dataEl.addAttribute("name", this.getName(), null);
        }
        if (this.getDescription() != null && this.getDescription().trim().length() > 0) {
            OMElement descEl = fac.createOMElement("description", null);
            descEl.setText(this.getDescription());
            dataEl.addChild((OMNode)descEl);
        }
        if (this.isBatchRequest()) {
            dataEl.addAttribute("enableBatchRequests", String.valueOf(this.isBatchRequest()), null);
        }
        if (this.isBoxcarring()) {
            dataEl.addAttribute("enableBoxcarring", String.valueOf(this.isBoxcarring()), null);
        }
        if (this.isDisableLegacyBoxcarringMode()) {
            dataEl.addAttribute("disableLegacyBoxcarringMode", String.valueOf(this.isDisableLegacyBoxcarringMode()), null);
        }
        if (this.isDisableStreaming()) {
            dataEl.addAttribute("disableStreaming", String.valueOf(this.isDisableStreaming()), null);
        }
        ArrayList<String> transports = new ArrayList<String>();
        if (this.isEnableHTTP()) {
            transports.add("http");
        }
        if (this.isEnableHTTPS()) {
            transports.add("https");
        }
        if (this.isEnableLocal()) {
            transports.add("local");
        }
        if (this.isEnableJMS()) {
            transports.add("jms");
        }
        if (transports.size() > 0) {
            String transportStr = "";
            for (String trn : transports) {
                transportStr = transportStr + " " + trn;
            }
            transportStr = transportStr.substring(1, transportStr.length());
            dataEl.addAttribute("transports", transportStr, null);
        }
        if (this.getServiceNamespace() != null && this.getServiceNamespace().trim().length() > 0) {
            dataEl.addAttribute("serviceNamespace", this.getServiceNamespace().trim(), null);
        }
        if (this.getSecureVaultNamespace() != null && this.getSecureVaultNamespace().trim().length() > 0) {
            dataEl.addAttribute("xmlns:svns", this.getSecureVaultNamespace(), null);
        }
        if (this.getPasswordProvider() != null && this.getProtectedTokens() != null && this.getPasswordProvider().trim().length() > 0 && this.getProtectedTokens().trim().length() > 0) {
            OMElement passwordManagerEl = fac.createOMElement("passwordManager", null);
            OMElement protectedTokensEl = fac.createOMElement("protectedTokens", null);
            protectedTokensEl.setText(this.getProtectedTokens());
            OMElement passwordProviderEl = fac.createOMElement("passwordProvider", null);
            passwordProviderEl.setText(this.getPasswordProvider());
            passwordManagerEl.addChild((OMNode)protectedTokensEl);
            passwordManagerEl.addChild((OMNode)passwordProviderEl);
            dataEl.addChild((OMNode)passwordManagerEl);
        }
        if (this.getStatus() != null && !this.getStatus().equals("active")) {
            dataEl.addAttribute("serviceStatus", this.getStatus(), null);
        }
        if (this.getConfigs() != null) {
            for (Config config : this.getConfigs()) {
                dataEl.addChild((OMNode)config.buildXML());
            }
        }
        if (this.getQueries() != null) {
            for (Query query : this.getQueries()) {
                dataEl.addChild((OMNode)query.buildXML());
            }
        }
        if (this.getEvents() != null) {
            for (Event event : this.getEvents()) {
                dataEl.addChild((OMNode)event.buildXML());
            }
        }
        if (this.getXADataSources() != null) {
            for (XADataSource xaDataSources : this.getXADataSources()) {
                dataEl.addChild((OMNode)xaDataSources.buildXML());
            }
        }
        if (this.getOperations() != null) {
            for (Operation operation : this.getOperations()) {
                dataEl.addChild((OMNode)operation.buildXML());
            }
        }
        if (this.getResources() != null) {
            for (Resource resource : this.getResources()) {
                dataEl.addChild((OMNode)resource.buildXML());
            }
        }
        if (this.getAuthProvider() != null) {
            dataEl.addChild((OMNode)this.getAuthProvider().buildXML());
        }
        return dataEl;
    }
}

