/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.ui;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dataservices.ui.beans.AuthProvider;
import org.wso2.carbon.dataservices.ui.stub.DataServiceAdminStub;
import org.wso2.carbon.dataservices.ui.stub.admin.core.xsd.PaginatedTableInfo;

public class DataServiceAdminClient {
    private DataServiceAdminStub stub = null;
    private static Log log = LogFactory.getLog(DataServiceAdminClient.class);

    public DataServiceAdminClient(String cookie, String url, ConfigurationContext configContext) throws AxisFault {
        String serviceEndPoint = null;
        try {
            serviceEndPoint = url + "DataServiceAdmin";
            this.stub = new DataServiceAdminStub(configContext, serviceEndPoint);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault e) {
            log.error((Object)("Error occurred while connecting via stub to : " + serviceEndPoint), (Throwable)e);
            throw e;
        }
    }

    public String validateJSONMapping(String jsonMapping) throws RemoteException {
        return this.stub.validateJSONMapping(jsonMapping);
    }

    public String getDataServiceContents(String serviceId) throws RemoteException {
        return this.stub.getDataServiceContentAsString(serviceId);
    }

    public String[] getCarbonDataSourceNames() throws RemoteException {
        return this.stub.getCarbonDataSourceNames();
    }

    public String getCarbonDataSourceType(String dsName) throws RemoteException {
        return this.stub.getCarbonDataSourceType(dsName);
    }

    public boolean isDSNameAvailable(String dataService) throws RemoteException {
        return this.stub.isDSNameAvailable(dataService);
    }

    public String[] getCarbonDataSourceNamesForTypes(String[] types) throws RemoteException {
        return this.stub.getCarbonDataSourceNamesForTypes(types);
    }

    public void saveDataService(String serviceName, String serviceGroup, String serviceContents) throws AxisFault {
        try {
            this.stub.saveDataService(serviceName, serviceGroup, serviceContents);
        }
        catch (RemoteException e) {
            log.error((Object)("Error occurred while saving dataservice : " + serviceName), (Throwable)e);
            throw new AxisFault("Saving " + serviceName + " failed.", (Throwable)e);
        }
    }

    public String testJDBCConnection(String driverClass, String jdbcURL, String username, String password, String passwordAlias) throws AxisFault {
        String response = "";
        try {
            response = this.stub.testJDBCConnection(driverClass, jdbcURL, username, password, passwordAlias);
        }
        catch (RemoteException e) {
            throw new AxisFault("Error connecting to " + jdbcURL + ". Message from the service is : ", (Throwable)e);
        }
        return response;
    }

    public String testGSpreadConnection(String clientId, String clientSecret, String refreshToken, String visibility, String documentURL) throws AxisFault {
        String response = "";
        try {
            response = this.stub.testGSpreadConnection(clientId, clientSecret, refreshToken, visibility, documentURL);
        }
        catch (RemoteException e) {
            throw new AxisFault("Error connecting to " + documentURL + ". Message from the service is : ", (Throwable)e);
        }
        return response;
    }

    public String[] getOutputColumnNames(String query) throws Exception {
        return this.stub.getOutputColumnNames(query);
    }

    public String[] getInputMappingNames(String query) throws Exception {
        return this.stub.getInputMappingNames(query);
    }

    public PaginatedTableInfo getPaginatedTableInfo(int pageNumber, String datasourceId, String dbName, String[] schemas) throws Exception {
        return this.stub.getPaginatedTableInfo(pageNumber, datasourceId, dbName, schemas);
    }

    public PaginatedTableInfo getPaginatedSchemaInfo(int pageNumber, String datasourceId) throws Exception {
        return this.stub.getPaginatedSchemaInfo(pageNumber, datasourceId);
    }

    public String[] getTableInfo(String datasourceId, String dbName, String[] schemas) throws Exception {
        return this.stub.getTableList(datasourceId, dbName, schemas);
    }

    public String[] getdbSchemaList(String datasourceId) throws Exception {
        return this.stub.getdbSchemaList(datasourceId);
    }

    public String[] getDSServiceList(String dataSourceId, String dbName, String[] schemas, String[] tableNames, String serviceNamespace) throws Exception {
        try {
            return this.stub.getDSServiceList(dataSourceId, dbName, schemas, tableNames, false, serviceNamespace);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public String getDSService(String dataSourceId, String dbName, String[] schemas, String[] tableNames, String serviceName, String serviceNamespace) throws Exception {
        try {
            return this.stub.getDSService(dataSourceId, dbName, schemas, tableNames, true, serviceName, serviceNamespace);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public String[] getAllRoles(AuthProvider authProvider) throws Exception {
        try {
            String authProviderConfig = null;
            if (authProvider != null) {
                authProviderConfig = authProvider.buildXML().toString();
            }
            String[] roles = this.stub.getAllRoles(authProviderConfig);
            return roles;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }
}

