/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.ui.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.wso2.carbon.dataservices.ui.beans.DataServiceConfigurationElement;
import org.wso2.carbon.dataservices.ui.beans.ExcelQuery;
import org.wso2.carbon.dataservices.ui.beans.GSpreadQuery;
import org.wso2.carbon.dataservices.ui.beans.Param;
import org.wso2.carbon.dataservices.ui.beans.Property;
import org.wso2.carbon.dataservices.ui.beans.Result;
import org.wso2.carbon.dataservices.ui.beans.SQLDialect;
import org.wso2.carbon.dataservices.ui.beans.Validator;

public class Query
extends DataServiceConfigurationElement {
    private String id;
    private Param[] params;
    private String sql;
    private String expression;
    private String sparql;
    private String configToUse = "";
    private Result result;
    private ExcelQuery excel;
    private GSpreadQuery gSpread;
    private String inputEventTrigger;
    private String outputEventTrigger;
    private String scraperVariable;
    private boolean returnGeneratedKeys;
    private boolean returnUpdatedRowCount;
    private String keyColumns;
    private ArrayList<Property> properties = new ArrayList();
    private List<SQLDialect> sqlDialects = new ArrayList<SQLDialect>();
    private String status = "add";

    public ArrayList<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        this.addProperty(property.getName(), property.getValue());
    }

    public void addProperty(String name, Object value) {
        Property property = new Property(name, value);
        this.properties.add(property);
    }

    public void updateProperty(String name, String value) {
        Iterator<Property> propertyItr = this.properties.iterator();
        boolean updated = false;
        while (propertyItr.hasNext()) {
            Property property = propertyItr.next();
            if (!property.getName().equals(name)) continue;
            if (value != null) {
                property.setValue(value);
            } else {
                property.setValue("");
            }
            updated = true;
            break;
        }
        if (!updated) {
            this.addProperty(name, value);
        }
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Param[] getParams() {
        return this.params;
    }

    public void setInputEventTrigger(String inputEventTrigger) {
        this.inputEventTrigger = inputEventTrigger;
    }

    public void setOutputEventTrigger(String outputEventTrigger) {
        this.outputEventTrigger = outputEventTrigger;
    }

    public String getInputEventTrigger() {
        return this.inputEventTrigger;
    }

    public String getOutputEventTrigger() {
        return this.outputEventTrigger;
    }

    public List<SQLDialect> getSqlDialects() {
        return this.sqlDialects;
    }

    public void setSqlDialects(List<SQLDialect> sqlDialects) {
        this.sqlDialects = sqlDialects;
    }

    public void addSqlDialects(String dialect, String value) {
        SQLDialect sqlDialect = new SQLDialect(dialect, value);
        this.sqlDialects.add(sqlDialect);
    }

    public SQLDialect removeSQLDialect(String dialect) {
        SQLDialect sqlDialect = new SQLDialect();
        for (int a = 0; a < this.sqlDialects.size(); ++a) {
            sqlDialect = this.sqlDialects.get(a);
            if (!sqlDialect.getDialect().equals(dialect)) continue;
            sqlDialect = this.sqlDialects.remove(a);
        }
        return sqlDialect;
    }

    public SQLDialect updateSQLDialect(String edit, String dialect, String sql) {
        SQLDialect sqlDialect = new SQLDialect();
        for (int a = 0; a < this.sqlDialects.size(); ++a) {
            sqlDialect = this.sqlDialects.get(a);
            if (!sqlDialect.getDialect().equals(edit)) continue;
            this.sqlDialects.get(a).setDialect(dialect);
            this.sqlDialects.get(a).setSql(sql);
        }
        return sqlDialect;
    }

    public boolean hasSQLDialects() {
        boolean hasSQLDialect = false;
        for (SQLDialect sqlDialect : this.getSqlDialects()) {
            if (sqlDialect.getDialect() == null || sqlDialect.getDialect().trim().length() <= 0 || sqlDialect.getSql() == null || sqlDialect.getSql().trim().length() <= 0) continue;
            hasSQLDialect = true;
            break;
        }
        return hasSQLDialect;
    }

    public void setParams(Param[] paramsArray) {
        this.params = new Param[paramsArray.length];
        for (int a = 0; a < paramsArray.length; ++a) {
            this.params[a] = paramsArray[a];
        }
    }

    public void addParam(Param newParam) {
        if (this.params != null) {
            Param[] newParams = new Param[this.params.length + 1];
            for (int a = 0; a < this.params.length; ++a) {
                newParams[a] = this.params[a];
            }
            newParams[newParams.length - 1] = newParam;
            this.params = newParams;
        } else {
            Param[] newParams = new Param[]{newParam};
            this.params = newParams;
            newParams[newParams.length - 1] = newParam;
        }
    }

    public void removeParam(Param removeParam) {
        if (this.params != null) {
            Param[] newParams = new Param[this.params.length - 1];
            ArrayList<Param> paramList = new ArrayList<Param>();
            Param param = new Param();
            paramList.add(param);
            paramList.remove(param);
            for (int a = 0; a < this.params.length - 1; ++a) {
                newParams[a] = this.params[a];
            }
            if (newParams.length > 0) {
                newParams[newParams.length] = removeParam;
                this.params = newParams;
            }
        }
    }

    public void removeParam(String name) {
        if (this.params != null) {
            int paramToBeRemoved = -1;
            Param[] existingParams = this.params;
            for (int i = 0; i < existingParams.length; ++i) {
                if (!existingParams[i].getName().equals(name)) continue;
                paramToBeRemoved = i;
                break;
            }
            if (paramToBeRemoved != -1) {
                int tmpIndex = 0;
                Param[] modifiedParams = new Param[existingParams.length - 1];
                for (int i = 0; i < existingParams.length; ++i) {
                    if (i == paramToBeRemoved) continue;
                    modifiedParams[tmpIndex] = existingParams[i];
                    ++tmpIndex;
                }
                this.params = modifiedParams;
            }
        }
    }

    public Param getParam(String name) {
        if (this.params != null) {
            for (int a = 0; a < this.params.length; ++a) {
                if (!this.params[a].getName().equals(name)) continue;
                return this.params[a];
            }
        }
        return null;
    }

    public Query() {
    }

    private List<Validator> getValidators(Iterator<OMElement> valItr) {
        ArrayList<Validator> vals = new ArrayList<Validator>();
        while (valItr.hasNext()) {
            OMElement valEl = valItr.next();
            String valElementName = valEl.getLocalName();
            Iterator attrItr = valEl.getAllAttributes();
            HashMap<String, String> propMap = new HashMap<String, String>();
            while (attrItr.hasNext()) {
                OMAttribute attr = (OMAttribute)attrItr.next();
                propMap.put(attr.getLocalName(), attr.getAttributeValue());
            }
            Map<String, String> customPropMap = this.extractAdvancedProps(valEl);
            vals.add(new Validator(valElementName, propMap, customPropMap));
        }
        return vals;
    }

    public Query(Iterator<OMElement> paramItr) {
        ArrayList<Param> paramList = new ArrayList<Param>();
        int ordinal = 0;
        while (paramItr.hasNext()) {
            ++ordinal;
            OMElement paramElement = paramItr.next();
            String userSetOrdinalValue = paramElement.getAttributeValue(new QName("ordinal"));
            if (userSetOrdinalValue == null || userSetOrdinalValue.trim().length() == 0) {
                userSetOrdinalValue = String.valueOf(ordinal);
            }
            Param param = new Param(paramElement.getAttributeValue(new QName("name")), paramElement.getAttributeValue(new QName("sqlType")), paramElement.getAttributeValue(new QName("type")), userSetOrdinalValue, paramElement.getAttributeValue(new QName("defaultValue")), this.getValidators(paramElement.getChildren()), paramElement.getAttributeValue(new QName("optional")));
            paramList.add(param);
        }
        try {
            Param[] params = new Param[paramList.size()];
            paramList.toArray(params);
            this.setParams(params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSparql() {
        return this.sparql;
    }

    public String getScraperVariable() {
        return this.scraperVariable;
    }

    public void setScraperVariable(String scraperVariable) {
        this.scraperVariable = scraperVariable;
    }

    public void setSparql(String sparql) {
        this.sparql = sparql;
    }

    public String getConfigToUse() {
        return this.configToUse;
    }

    public void setConfigToUse(String configToUse) {
        this.configToUse = configToUse;
    }

    public void setExcel(ExcelQuery excel) {
        this.excel = excel;
    }

    public ExcelQuery getExcel() {
        return this.excel;
    }

    public boolean isReturnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }

    public void setReturnGeneratedKeys(boolean returnGeneratedKeys) {
        this.returnGeneratedKeys = returnGeneratedKeys;
    }

    public boolean isReturnUpdatedRowCount() {
        return this.returnUpdatedRowCount;
    }

    public void setReturnUpdatedRowCount(boolean returnUpdatedRowCount) {
        this.returnUpdatedRowCount = returnUpdatedRowCount;
    }

    public String getKeyColumns() {
        return this.keyColumns;
    }

    public void setKeyColumns(String keyColumns) {
        this.keyColumns = keyColumns;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean hasProperties() {
        boolean hasProperty = false;
        for (Property property : this.getProperties()) {
            if (property.getValue() == null || property.getValue().equals("")) continue;
            hasProperty = true;
            break;
        }
        return hasProperty;
    }

    @Override
    public OMElement buildXML() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement queryEl = fac.createOMElement("query", null);
        if (this.getId() != null) {
            queryEl.addAttribute("id", this.getId(), null);
        }
        if (this.getConfigToUse() != null) {
            queryEl.addAttribute("useConfig", this.getConfigToUse(), null);
        }
        if (this.getInputEventTrigger() != null && this.getInputEventTrigger().trim().length() > 0) {
            queryEl.addAttribute("input-event-trigger", this.getInputEventTrigger().trim(), null);
        }
        if (this.getOutputEventTrigger() != null && this.getOutputEventTrigger().trim().length() > 0) {
            queryEl.addAttribute("output-event-trigger", this.getOutputEventTrigger().trim(), null);
        }
        if (this.isReturnGeneratedKeys()) {
            queryEl.addAttribute("returnGeneratedKeys", String.valueOf(this.isReturnGeneratedKeys()), null);
        }
        if (this.isReturnUpdatedRowCount()) {
            queryEl.addAttribute("returnUpdatedRowCount", String.valueOf(this.isReturnUpdatedRowCount()), null);
        }
        if (this.getKeyColumns() != null && this.getKeyColumns().trim().length() > 0) {
            queryEl.addAttribute("keyColumns", this.getKeyColumns().trim(), null);
        }
        if (this.getSql() != null) {
            OMElement sqlEl = fac.createOMElement("sql", null);
            sqlEl.setText(this.getSql().trim());
            queryEl.addChild((OMNode)sqlEl);
        } else if (this.getExpression() != null) {
            OMElement expEl = fac.createOMElement("expression", null);
            expEl.setText(this.getExpression().trim());
            queryEl.addChild((OMNode)expEl);
        } else if (this.getSparql() != null) {
            OMElement sparqlEl = fac.createOMElement("sparql", null);
            OMTextImpl omText = (OMTextImpl)fac.createOMText(this.getSparql());
            omText.setType(12);
            sparqlEl.addChild((OMNode)omText);
            queryEl.addChild((OMNode)sparqlEl);
        } else if (this.getExcel() != null) {
            queryEl.addChild((OMNode)this.getExcel().buildXML());
        } else if (this.getScraperVariable() != null) {
            OMElement scraperEl = fac.createOMElement("scraperVariable", null);
            scraperEl.setText(this.getScraperVariable());
            queryEl.addChild((OMNode)scraperEl);
        } else if (this.getGSpread() != null) {
            queryEl.addChild((OMNode)this.getGSpread().buildXML());
        }
        if (this.hasProperties()) {
            OMElement propEl = fac.createOMElement("properties", null);
            for (Property property : this.getProperties()) {
                if (property.getValue() == null || property.getValue().equals("")) continue;
                propEl.addChild((OMNode)property.buildXML());
            }
            queryEl.addChild((OMNode)propEl);
        }
        if (this.hasSQLDialects()) {
            for (SQLDialect sqlDialect : this.getSqlDialects()) {
                queryEl.addChild((OMNode)sqlDialect.buildXML());
            }
        }
        if (this.getResult() != null && (this.getResult().getAttributes().size() > 0 || this.getResult().getElements().size() > 0 || this.getResult().getCallQueryGroups().size() > 0 || this.getResult().getComplexElements().size() > 0 || this.getResult().getResources().size() > 0 || "json".equals(this.getResult().getOutputType()) && this.getResult().getTextMapping().trim().length() > 0)) {
            queryEl.addChild((OMNode)this.getResult().buildXML());
        }
        if (this.getParams() != null) {
            for (int a = 0; a < this.getParams().length; ++a) {
                Param param = this.getParams()[a];
                queryEl.addChild((OMNode)param.buildXML());
            }
        }
        return queryEl;
    }

    public GSpreadQuery getGSpread() {
        return this.gSpread;
    }

    public void setGSpread(GSpreadQuery gSpread) {
        this.gSpread = gSpread;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

