/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.reader.hadoop;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import org.apache.hadoop.conf.Configuration;
import org.wso2.carbon.datasource.reader.hadoop.HadoopConfigProperty;
import org.wso2.carbon.datasource.reader.hadoop.HadoopDataSourceConfiguration;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.utils.CarbonUtils;

public class HadoopDataSourceReaderUtil {
    public static Configuration loadConfig(String xmlConfiguration) throws DataSourceException {
        ByteArrayInputStream baos = null;
        try {
            HadoopConfigProperty[] properties;
            xmlConfiguration = CarbonUtils.replaceSystemVariablesInXml((String)xmlConfiguration);
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{HadoopDataSourceConfiguration.class});
            baos = new ByteArrayInputStream(xmlConfiguration.getBytes());
            HadoopDataSourceConfiguration fileConfig = (HadoopDataSourceConfiguration)ctx.createUnmarshaller().unmarshal((InputStream)baos);
            Configuration config = new Configuration();
            for (HadoopConfigProperty configEntry : properties = fileConfig.getConfigProperties()) {
                if ("".equals(configEntry.getPropertyName()) || "".equals(configEntry.getPropertyValue())) continue;
                config.set(configEntry.getPropertyName(), configEntry.getPropertyValue());
            }
            Configuration configuration = config;
            return configuration;
        }
        catch (Exception e) {
            throw new DataSourceException("Error loading Hadoop configuration: " + e.getMessage(), e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

