/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.reader.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.wso2.carbon.datasource.reader.hadoop.HadoopDataSourceReaderUtil;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.common.spi.DataSourceReader;

public class HDFSDataSourceReader
implements DataSourceReader {
    public String getType() {
        return "HDFS";
    }

    public Object createDataSource(String xmlConfig, boolean isDataSourceFactoryReference) throws DataSourceException {
        return HadoopDataSourceReaderUtil.loadConfig(xmlConfig);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testDataSourceConnection(String xmlConfig) throws DataSourceException {
        Configuration config = (Configuration)this.createDataSource(xmlConfig, true);
        try (FileSystem fileSystem = FileSystem.get((Configuration)config);){
            boolean bl = fileSystem == null;
            return bl;
        }
        catch (IOException e) {
            throw new DataSourceException("Cannot establish connection to HDFS instance for testing: " + e.getMessage(), (Exception)e);
        }
    }
}

