/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.reader.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import org.wso2.carbon.datasource.reader.mongo.config.MongoDataSourceConfiguration;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.utils.CarbonUtils;

public class MongoDataSourceReaderUtil {
    public static MongoClient loadConfiguration(String xmlConfiguration) throws DataSourceException {
        ByteArrayInputStream baos = null;
        try {
            xmlConfiguration = CarbonUtils.replaceSystemVariablesInXml((String)xmlConfiguration);
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{MongoDataSourceConfiguration.class});
            baos = new ByteArrayInputStream(xmlConfiguration.getBytes());
            MongoDataSourceConfiguration fileConfig = (MongoDataSourceConfiguration)ctx.createUnmarshaller().unmarshal((InputStream)baos);
            MongoClient result = null;
            if (fileConfig.getUrl() != null) {
                MongoClientURI uri = new MongoClientURI(fileConfig.getUrl());
                result = new MongoClient(uri);
            } else {
                ArrayList<ServerAddress> addressList = new ArrayList<ServerAddress>();
                if (fileConfig.getReplicaSetConfig() != null) {
                    ServerAddress address1 = new ServerAddress(fileConfig.getReplicaSetConfig().getHost1(), Integer.parseInt(fileConfig.getReplicaSetConfig().getPort1()));
                    addressList.add(address1);
                    if (fileConfig.getReplicaSetConfig().getHost2() != null && fileConfig.getReplicaSetConfig().getPort2() != null) {
                        ServerAddress address2 = new ServerAddress(fileConfig.getReplicaSetConfig().getHost2(), Integer.parseInt(fileConfig.getReplicaSetConfig().getPort2()));
                        addressList.add(address2);
                    }
                    if (fileConfig.getReplicaSetConfig().getHost3() != null && fileConfig.getReplicaSetConfig().getPort3() != null) {
                        ServerAddress address3 = new ServerAddress(fileConfig.getReplicaSetConfig().getHost3(), Integer.parseInt(fileConfig.getReplicaSetConfig().getPort3()));
                        addressList.add(address3);
                    }
                } else {
                    ServerAddress address = new ServerAddress(fileConfig.getHost(), Integer.parseInt(fileConfig.getPort()));
                    addressList.add(address);
                }
                MongoClientOptions.Builder builder = MongoClientOptions.builder();
                MongoCredential credential = null;
                if (fileConfig.getWithSSL() != null) {
                    builder.sslEnabled(fileConfig.getWithSSL().booleanValue());
                }
                if (fileConfig.getAuthenticationMethodEnum() != null && fileConfig.getUsername() != null) {
                    credential = MongoDataSourceReaderUtil.createCredentials(fileConfig);
                }
                result = credential != null ? new MongoClient(addressList, Arrays.asList(credential), builder.build()) : new MongoClient(addressList, builder.build());
            }
            MongoClient mongoClient = result;
            return mongoClient;
        }
        catch (Exception e) {
            throw new DataSourceException("Error loading Mongo Datasource configuration: " + e.getMessage(), e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private static MongoCredential createCredentials(MongoDataSourceConfiguration fileConfig) {
        MongoCredential credential;
        switch (fileConfig.getAuthenticationMethodEnum()) {
            case SCRAM_SHA_1: {
                credential = MongoCredential.createScramSha1Credential((String)fileConfig.getUsername(), (String)fileConfig.getDatabase(), (char[])fileConfig.getPassword().toCharArray());
                break;
            }
            case MONGODB_CR: {
                credential = MongoCredential.createMongoCRCredential((String)fileConfig.getUsername(), (String)fileConfig.getDatabase(), (char[])fileConfig.getPassword().toCharArray());
            }
            case LDAP_PLAIN: {
                credential = MongoCredential.createPlainCredential((String)fileConfig.getUsername(), (String)fileConfig.getAuthSource(), (char[])fileConfig.getPassword().toCharArray());
            }
            case X_509: {
                credential = MongoCredential.createMongoX509Credential((String)fileConfig.getUsername());
            }
            case GSSAPI: {
                credential = MongoCredential.createGSSAPICredential((String)fileConfig.getUsername());
            }
            default: {
                credential = MongoCredential.createCredential((String)fileConfig.getUsername(), (String)fileConfig.getDatabase(), (char[])fileConfig.getPassword().toCharArray());
            }
        }
        return credential;
    }
}

