/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dbconsole.ui.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.server.web.WebServlet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class DBConsoleComponent {
    private HttpService httpService = null;
    private static Log log = LogFactory.getLog(DBConsoleComponent.class);

    protected void activate(ComponentContext context) {
        try {
            this.registerServlet(context.getBundleContext());
            log.debug((Object)"******* DB Console bundle is activated ******* ");
        }
        catch (Throwable e) {
            log.error((Object)"******* Failed to activate DB Console bundle ******* ", e);
        }
    }

    public void registerServlet(BundleContext bundleContext) throws Exception {
        HttpContext defaultHttpContext = this.httpService.createDefaultHttpContext();
        Hashtable<String, String> servletParam = new Hashtable<String, String>(2);
        ((Dictionary)servletParam).put("-webAllowOthers", "");
        this.httpService.registerServlet("/dbconsole", (Servlet)new WebServlet(), servletParam, defaultHttpContext);
    }

    protected void deactivate(ComponentContext context) {
        this.httpService.unregister("/dbconsole");
        log.debug((Object)"******* DB Console bundle is deactivated ******* ");
    }

    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }
}

