/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.core.beans;

import java.util.Hashtable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.wso2.carbon.datasource.utils.DataSourceUtils;

@XmlRootElement(name="jndiConfig")
public class JNDIConfig {
    private String name;
    private EnvEntry[] environment;
    private boolean useJndiReference = false;

    public void setName(String name) {
        this.name = name;
    }

    public void setEnvironment(EnvEntry[] environment) {
        this.environment = new EnvEntry[environment.length];
        for (int i = 0; i < environment.length; ++i) {
            this.environment[i] = environment[i].copy();
        }
    }

    @XmlElement(name="name", required=true, nillable=false)
    public String getName() {
        return this.name;
    }

    @XmlElementWrapper(name="environment", nillable=false)
    @XmlElement(name="property")
    public EnvEntry[] getEnvironment() {
        if (this.environment == null) {
            return new EnvEntry[0];
        }
        EnvEntry[] tempEnvironment = new EnvEntry[this.environment.length];
        for (int i = 0; i < this.environment.length; ++i) {
            tempEnvironment[i] = this.environment[i].copy();
        }
        return tempEnvironment;
    }

    @XmlElement(name="useJndiReference")
    public boolean isUseJndiReference() {
        return this.useJndiReference;
    }

    public void setUseJndiReference(boolean useJndiReference) {
        this.useJndiReference = useJndiReference;
    }

    public Hashtable<String, String> extractHashtableEnv() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        for (EnvEntry entry : this.getEnvironment()) {
            env.put(entry.getName(), entry.getValue());
        }
        return env;
    }

    public JNDIConfig copy() {
        JNDIConfig result = new JNDIConfig();
        result.setName(this.getName());
        result.setUseJndiReference(this.isUseJndiReference());
        EnvEntry[] envEntries = null;
        EnvEntry[] origEntries = this.getEnvironment();
        envEntries = new EnvEntry[origEntries.length];
        for (int i = 0; i < origEntries.length; ++i) {
            envEntries[i] = new EnvEntry();
            envEntries[i].setName(origEntries[i].getName());
            envEntries[i].setValue(origEntries[i].getValue());
        }
        result.setEnvironment(envEntries);
        return result;
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof JNDIConfig)) {
            return false;
        }
        JNDIConfig jc = (JNDIConfig)rhs;
        if (!DataSourceUtils.nullAllowEquals(jc.getName(), this.getName())) {
            return false;
        }
        return DataSourceUtils.nullAllowEquals(jc.extractHashtableEnv(), this.extractHashtableEnv());
    }

    public int hashCode() {
        assert (false) : "hashCode() not implemented";
        return -1;
    }

    @XmlRootElement(name="property")
    public static class EnvEntry {
        private String name;
        private boolean encrypted = true;
        private String value;

        @XmlAttribute(name="encrypted")
        public boolean isEncrypted() {
            return this.encrypted;
        }

        public void setEncrypted(boolean encrypted) {
            this.encrypted = encrypted;
        }

        @XmlAttribute(name="name")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlValue
        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public EnvEntry copy() {
            EnvEntry temp = new EnvEntry();
            temp.setEncrypted(this.isEncrypted());
            temp.setName(this.getName());
            temp.setValue(this.getValue());
            return temp;
        }
    }
}

