/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.rdbms.tomcat;

import java.lang.management.ManagementFactory;
import java.sql.SQLException;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.datasource.rdbms.tomcat.TomcatDataSourceConfiguration;
import org.wso2.carbon.datasource.rdbms.tomcat.utils.TomcatDataSourceUtils;
import org.wso2.carbon.datasource.utils.DataSourceUtils;

public class TomcatDataSource {
    private static Logger logger = LoggerFactory.getLogger(TomcatDataSource.class);
    private static final String STANDARD_TOMCAT_JDBC_INTERCEPTORS = "ConnectionState;StatementFinalizer;org.wso2.carbon.datasource.rdbms.tomcat.ConnectionRollbackOnReturnInterceptor;";
    private DataSource dataSource;
    private Reference dataSourceFactoryReference;
    private PoolConfiguration poolProperties;

    public TomcatDataSource(TomcatDataSourceConfiguration config) throws DataSourceException {
        this.poolProperties = TomcatDataSourceUtils.createPoolConfiguration(config);
        this.populateStandardProps();
    }

    private void populateStandardProps() {
        String jdbcInterceptors = this.poolProperties.getJdbcInterceptors();
        if (jdbcInterceptors == null) {
            jdbcInterceptors = "";
        }
        jdbcInterceptors = STANDARD_TOMCAT_JDBC_INTERCEPTORS + jdbcInterceptors;
        this.poolProperties.setJdbcInterceptors(jdbcInterceptors);
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = new DataSource(this.poolProperties);
        }
        if (this.poolProperties.isJmxEnabled()) {
            this.registerMBean();
        }
        return this.dataSource;
    }

    private void registerMBean() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        String mBean = "";
        try {
            if (DataSourceUtils.getCurrentDataSourceId() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The current dataSource id is not set");
                }
                return;
            }
            String[] dataSourceId = DataSourceUtils.getCurrentDataSourceId().split(":");
            mBean = dataSourceId[1] + "," + dataSourceId[0];
            ObjectName objectName = new ObjectName(mBean + ":type=DataSource");
            mBeanServer.registerMBean(this.dataSource.createPool().getJmxPool(), objectName);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.warn("Registering already existing mbean. '" + mBean + "' " + e.getMessage(), (Throwable)e);
        }
        catch (SQLException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            logger.error("Error while registering the MBean for dataSource '" + mBean + " " + e.getMessage(), (Throwable)e);
        }
    }

    public Reference getDataSourceFactoryReference() throws DataSourceException {
        if (this.dataSourceFactoryReference == null) {
            this.dataSourceFactoryReference = new Reference("org.apache.tomcat.jdbc.pool.DataSource", "org.apache.tomcat.jdbc.pool.DataSourceFactory", null);
            Map<String, String> poolConfigMap = DataSourceUtils.extractPrimitiveFieldNameValuePairs(this.poolProperties);
            poolConfigMap.forEach((key, value) -> this.dataSourceFactoryReference.add(new StringRefAddr((String)key, (String)value)));
        }
        return this.dataSourceFactoryReference;
    }
}

