/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.kernel.utils.Utils;
import org.xml.sax.SAXException;

public class DataSourceUtils {
    private static Logger logger = LoggerFactory.getLogger(DataSourceUtils.class);
    private static final String[] CLASS_RETURN_TYPES = new String[]{"String", "Byte", "Character", "Short", "Integer", "Float", "Double", "Character", "Boolean"};
    private static final String XML_DECLARATION = "xml-declaration";
    private static final String DATASOURCES_DIRECTORY_NAME = "datasources";
    private static ThreadLocal<String> dataSourceId = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };

    public static String getCurrentDataSourceId() {
        return dataSourceId.get();
    }

    public static boolean nullAllowEquals(Object lhs, Object rhs) {
        return lhs == null && rhs == null || (lhs != null || rhs == null) && (lhs == null || rhs != null) && lhs != null && lhs.equals(rhs);
    }

    public static String elementToString(Element element) {
        try {
            if (element == null) {
                return "";
            }
            Document document = element.getOwnerDocument();
            DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
            LSSerializer serializer = domImplLS.createLSSerializer();
            serializer.getDomConfig().setParameter(XML_DECLARATION, false);
            return serializer.writeToString(element);
        }
        catch (Exception e) {
            logger.error("Error while converting element to string: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Document convertToDocument(File file) throws DataSourceException {
        try {
            return DataSourceUtils.getSecuredDocumentBuilder(false).parse(file);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new DataSourceException("Error in creating an XML document from file: " + e.getMessage(), e);
        }
    }

    private static DocumentBuilder getSecuredDocumentBuilder(boolean setIgnoreComments) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(setIgnoreComments);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver((publicId, systemId) -> {
            throw new SAXException("Possible XML External Entity (XXE) attack. Skip resolving entity");
        });
        return documentBuilder;
    }

    public static Path getDataSourceConfigPath() {
        return Utils.getCarbonConfigHome().resolve(DATASOURCES_DIRECTORY_NAME);
    }

    public static InputStream replaceSystemVariablesInXml(InputStream xmlConfiguration) throws DataSourceException {
        Document doc;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver((publicId, systemId) -> {
                throw new SAXException("Possible XML External Entity (XXE) attack. Skip resolving entity");
            });
            doc = documentBuilder.parse(xmlConfiguration);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new DataSourceException("Error in building Document", e);
        }
        NodeList nodeList = null;
        if (doc != null) {
            nodeList = doc.getElementsByTagName("*");
        }
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                DataSourceUtils.resolveLeafNodeValue(nodeList.item(i));
            }
        }
        return DataSourceUtils.toInputStream(doc);
    }

    public static InputStream toInputStream(Document doc) throws DataSourceException {
        ByteArrayInputStream in;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DOMSource xmlSource = new DOMSource(doc);
            StreamResult result = new StreamResult(outputStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlSource, result);
            in = new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (TransformerException e) {
            throw new DataSourceException("Error in transforming DOM to InputStream", e);
        }
        return in;
    }

    public static void resolveLeafNodeValue(Node node) {
        if (node != null) {
            Element element = (Element)node;
            NodeList childNodeList = element.getChildNodes();
            for (int j = 0; j < childNodeList.getLength(); ++j) {
                Node chileNode = childNodeList.item(j);
                if (!chileNode.hasChildNodes()) {
                    String nodeValue = DataSourceUtils.resolveSystemProperty(chileNode.getTextContent());
                    childNodeList.item(j).setTextContent(nodeValue);
                    continue;
                }
                DataSourceUtils.resolveLeafNodeValue(chileNode);
            }
        }
    }

    public static String replaceSystemVariablesInXml(String xmlConfiguration) throws DataSourceException {
        InputStream in = DataSourceUtils.replaceSystemVariablesInXml(new ByteArrayInputStream(xmlConfiguration.getBytes(StandardCharsets.UTF_8)));
        try {
            xmlConfiguration = IOUtils.toString((InputStream)in);
        }
        catch (IOException e) {
            throw new DataSourceException("Error in converting InputStream to String", e);
        }
        return xmlConfiguration;
    }

    public static String resolveSystemProperty(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        while (indexOfStartingChars < text.indexOf("${") && (indexOfStartingChars = text.indexOf("${")) != -1 && (indexOfClosingBrace = text.indexOf(125)) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(sysProp);
            if (propValue != null) {
                text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
            if (!sysProp.equals("carbon.home") || propValue == null || !propValue.equals(".")) continue;
            text = new File(".").getAbsolutePath() + File.separator + text;
        }
        return text;
    }

    public static Map<String, String> extractPrimitiveFieldNameValuePairs(Object object) throws DataSourceException {
        Method[] methods;
        HashMap<String, String> nameValueMap = new HashMap<String, String>();
        for (Method method : methods = object.getClass().getMethods()) {
            if (!DataSourceUtils.isMethodMatched(method)) continue;
            String fieldName = DataSourceUtils.getFieldNameFromMethodName(method.getName());
            try {
                if (method.invoke(object, new Object[0]) == null) continue;
                String result = method.invoke(object, new Object[0]).toString();
                nameValueMap.put(fieldName, result);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new DataSourceException("Error in retrieving " + fieldName + " value from the object :" + object.getClass() + e.getMessage(), e);
            }
        }
        return nameValueMap;
    }

    private static String getFieldNameFromMethodName(String name) throws DataSourceException {
        String firstLetter;
        String prefixGet = "get";
        String prefixIs = "is";
        if (name.startsWith(prefixGet)) {
            firstLetter = name.substring(3, 4);
            name = name.substring(4);
        } else if (name.startsWith(prefixIs)) {
            firstLetter = name.substring(2, 3);
            name = name.substring(3);
        } else {
            throw new DataSourceException("Error in retrieving attribute name from method : " + name);
        }
        firstLetter = firstLetter.toLowerCase(Locale.getDefault());
        return firstLetter.concat(name);
    }

    private static boolean isMethodMatched(Method method) {
        String returnType = method.getReturnType().getSimpleName();
        String methodName = method.getName();
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (returnType.equals("void")) {
            return false;
        }
        if (!(methodName.startsWith("get") || methodName.startsWith("is") && (returnType.equals("Boolean") || returnType.equals("boolean")))) {
            return false;
        }
        return method.getReturnType().isPrimitive() || Arrays.asList(CLASS_RETURN_TYPES).contains(returnType);
    }

    public static <T, U> T loadJAXBConfiguration(U configuration, Class<T> clazz) throws DataSourceException {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{clazz});
            if (configuration instanceof File) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Parsing configuration file: " + ((File)configuration).getName());
                }
                Document doc = DataSourceUtils.convertToDocument((File)configuration);
                return (T)ctx.createUnmarshaller().unmarshal((Node)doc);
            }
            if (configuration instanceof String) {
                String xmlConfiguration = DataSourceUtils.replaceSystemVariablesInXml((String)configuration);
                return (T)ctx.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlConfiguration.getBytes(StandardCharsets.UTF_8)));
            }
            throw new DataSourceException("Only a file or string content allowed as the first parameter.");
        }
        catch (JAXBException e) {
            throw new DataSourceException("Error occurred while converting configuration into jaxb beans", e);
        }
    }
}

