/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.datasource.core.DataSourceBuilder;
import org.wso2.carbon.datasource.core.DataSourceJndiManager;
import org.wso2.carbon.datasource.core.DataSourceRepository;
import org.wso2.carbon.datasource.core.beans.CarbonDataSource;
import org.wso2.carbon.datasource.core.beans.DataSourceDefinition;
import org.wso2.carbon.datasource.core.beans.DataSourceMetadata;
import org.wso2.carbon.datasource.core.beans.DataSourcesConfiguration;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.datasource.core.spi.DataSourceReader;

public class DataSourceManager {
    private static Logger logger = LoggerFactory.getLogger(DataSourceManager.class);
    private static DataSourceManager instance = new DataSourceManager();
    private static final String WSO2_DATASOURCES_NAMESPACE = "wso2.datasources";
    private static final String DATASOURCES_NAMESPACE = "dataSources";
    private DataSourceRepository dataSourceRepository;
    private Map<String, DataSourceReader> dataSourceReaders = new HashMap<String, DataSourceReader>();
    private boolean initialized = false;

    private DataSourceManager() {
        this.dataSourceRepository = new DataSourceRepository();
    }

    public static DataSourceManager getInstance() {
        return instance;
    }

    public DataSourceRepository getDataSourceRepository() {
        return this.dataSourceRepository;
    }

    public List<String> getDataSourceTypes() {
        return new ArrayList<String>(this.dataSourceReaders.keySet());
    }

    public DataSourceReader getDataSourceReader(String dataSourceType) throws DataSourceException {
        DataSourceReader reader = this.dataSourceReaders.get(dataSourceType);
        if (reader == null) {
            throw new DataSourceException("No reader found for type: " + dataSourceType);
        }
        return reader;
    }

    public void initDataSources(ConfigProvider configProvider) throws DataSourceException {
        this.loadDataSourceProviders();
        this.initDataSources(configProvider, this.dataSourceReaders);
    }

    public void initDataSources(ConfigProvider configProvider, Map<String, DataSourceReader> dataSourceReaders) throws DataSourceException {
        this.dataSourceReaders = dataSourceReaders;
        if (this.initialized) {
            logger.debug("Data sources are already initialized.");
            return;
        }
        logger.debug("Initializing the data sources.");
        if (dataSourceReaders.isEmpty()) {
            throw new RuntimeException("No data source readers found. Data sources will not be initialized!");
        }
        DataSourcesConfiguration dataSourceConfiguration = null;
        try {
            if (configProvider.getConfigurationObject(DATASOURCES_NAMESPACE) != null) {
                ArrayList dataSourceList = configProvider.getConfigurationObjectList(DATASOURCES_NAMESPACE, DataSourceMetadata.class);
                if (dataSourceList.isEmpty()) {
                    throw new DataSourceException("Configuration 'dataSources' doesn't specify any datasource configurations");
                }
                dataSourceConfiguration = new DataSourcesConfiguration();
                dataSourceConfiguration.setDataSources(dataSourceList);
            } else if (configProvider.getConfigurationObject(WSO2_DATASOURCES_NAMESPACE) != null && (dataSourceConfiguration = (DataSourcesConfiguration)configProvider.getConfigurationObject(DataSourcesConfiguration.class)).getDataSources() == null && dataSourceConfiguration.getDataSources().isEmpty()) {
                throw new DataSourceException("Configuration doesn't specify any datasource configurations");
            }
        }
        catch (ConfigurationException e) {
            throw new DataSourceException("Error while reading datasource configuration from file", e);
        }
        if (dataSourceConfiguration != null) {
            for (DataSourceMetadata dsmInfo : dataSourceConfiguration.getDataSources()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating datasource object| datasource name: " + dsmInfo.getName());
                }
                if (dsmInfo == null || dsmInfo.getDefinition() == null) continue;
                try {
                    DataSourceReader dataSourceReader = this.getDataSourceReader(dsmInfo.getDefinition().getType());
                    CarbonDataSource carbonDataSource = DataSourceBuilder.buildCarbonDataSource(dsmInfo, dataSourceReader);
                    this.dataSourceRepository.addDataSource(carbonDataSource);
                    DataSourceJndiManager.register(carbonDataSource, dataSourceReader);
                }
                catch (NamingException | DataSourceException e) {
                    throw new DataSourceException("Error while initializing the datasource: " + dsmInfo.getName(), e);
                }
            }
        }
        this.initialized = true;
    }

    private void loadDataSourceProviders() {
        if (this.dataSourceReaders.size() == 0) {
            ServiceLoader<DataSourceReader> dsReaderLoader = ServiceLoader.load(DataSourceReader.class);
            dsReaderLoader.forEach(reader -> this.dataSourceReaders.put(reader.getType(), (DataSourceReader)reader));
        }
    }

    public Object createDataSource(DataSourceDefinition dataSourceDefinition) throws DataSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating datasoure object of type: " + dataSourceDefinition.getType());
        }
        try {
            DataSourceReader dataSourceReader = this.getDataSourceReader(dataSourceDefinition.getType());
            return DataSourceBuilder.buildDataSourceObject(dataSourceReader, false, dataSourceDefinition);
        }
        catch (DataSourceException e) {
            throw new DataSourceException("Error creating data source object of type: " + dataSourceDefinition.getType() + " - " + e.getMessage(), e);
        }
    }
}

