/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.core;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.datasource.core.DataSourceBuilder;
import org.wso2.carbon.datasource.core.beans.CarbonDataSource;
import org.wso2.carbon.datasource.core.beans.DataSourceMetadata;
import org.wso2.carbon.datasource.core.beans.JNDIConfig;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.datasource.core.spi.DataSourceReader;

public class DataSourceJndiManager {
    private static final String JAVA_COMP_CONTEXT_STRING = "java:comp";
    private static final String ENV_CONTEXT_STRING = "env";
    private static final Logger logger = LoggerFactory.getLogger(DataSourceJndiManager.class);

    public static void register(CarbonDataSource carbonDataSource, DataSourceReader dataSourceReader) throws DataSourceException, NamingException {
        DataSourceJndiManager.register(carbonDataSource.getMetadata(), carbonDataSource.getDataSourceObject(), dataSourceReader);
    }

    public static void register(DataSourceMetadata dataSourceMetadata, Object dataSourceObject, DataSourceReader dataSourceReader) throws DataSourceException, NamingException {
        JNDIConfig jndiConfig = dataSourceMetadata.getJndiConfig();
        if (jndiConfig == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("JNDI info not found for " + dataSourceMetadata.getName());
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Registering " + dataSourceMetadata.getName() + " into JNDI context");
        }
        Context subContext = DataSourceJndiManager.getBindingContext(jndiConfig);
        if (jndiConfig.isUseJndiReference()) {
            dataSourceObject = DataSourceBuilder.buildDataSourceObject(dataSourceMetadata, true, dataSourceReader);
        }
        String[] tokens = jndiConfig.getName().split("/");
        subContext.rebind(tokens[tokens.length - 1], dataSourceObject);
    }

    private static Context getBindingContext(JNDIConfig jndiConfig) throws DataSourceException, NamingException {
        InitialContext context = new InitialContext(jndiConfig.extractHashtableEnv());
        return DataSourceJndiManager.checkAndCreateJNDISubContexts(context, jndiConfig);
    }

    private static Context checkAndCreateJNDISubContexts(Context context, JNDIConfig jndiConfig) throws DataSourceException, NamingException {
        String jndiName = "java:comp/env/" + jndiConfig.getName();
        String[] tokens = jndiName.split("/");
        Context tmpCtx = context;
        Context subContext = null;
        for (int i = 0; i < tokens.length - 1; ++i) {
            String token = tokens[i];
            subContext = DataSourceJndiManager.lookupJNDISubContext(tmpCtx, token);
            if (subContext == null) {
                subContext = tmpCtx.createSubcontext(token);
            }
            tmpCtx = subContext;
        }
        return subContext;
    }

    private static Context lookupJNDISubContext(Context context, String jndiName) throws DataSourceException, NamingException {
        try {
            Object obj = context.lookup(jndiName);
            if (!(obj instanceof Context)) {
                throw new DataSourceException("Non JNDI context exists at '" + context + "/" + jndiName);
            }
            return (Context)obj;
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }

    public static void unregister(CarbonDataSource cds) throws NamingException {
        JNDIConfig jndiConfig;
        if (logger.isDebugEnabled()) {
            logger.debug("Unregistering data source: " + cds.getMetadata().getName());
        }
        if ((jndiConfig = cds.getMetadata().getJndiConfig()) == null) {
            return;
        }
        InitialContext context = new InitialContext(jndiConfig.extractHashtableEnv());
        String jndiName = "java:comp/env/" + jndiConfig.getName();
        context.unbind(jndiName);
    }
}

