/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.core.impl;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.wso2.carbon.datasource.core.DataSourceBuilder;
import org.wso2.carbon.datasource.core.DataSourceJndiManager;
import org.wso2.carbon.datasource.core.DataSourceManager;
import org.wso2.carbon.datasource.core.DataSourceRepository;
import org.wso2.carbon.datasource.core.api.DataSourceManagementService;
import org.wso2.carbon.datasource.core.beans.CarbonDataSource;
import org.wso2.carbon.datasource.core.beans.DataSourceMetadata;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.datasource.core.spi.DataSourceReader;

public class DataSourceManagementServiceImpl
implements DataSourceManagementService {
    @Override
    public List<DataSourceMetadata> getDataSource() throws DataSourceException {
        return new ArrayList<DataSourceMetadata>(DataSourceManager.getInstance().getDataSourceRepository().getMetadata());
    }

    @Override
    public DataSourceMetadata getDataSource(String dataSourceName) throws DataSourceException {
        return DataSourceManager.getInstance().getDataSourceRepository().getMetadata(dataSourceName);
    }

    @Override
    public void addDataSource(DataSourceMetadata dataSourceMetadata) throws DataSourceException {
        DataSourceManager dataSourceManager = DataSourceManager.getInstance();
        String dataSourceType = dataSourceMetadata.getDefinition().getType();
        DataSourceReader dataSourceReader = dataSourceManager.getDataSourceReader(dataSourceType);
        CarbonDataSource cds = DataSourceBuilder.buildCarbonDataSource(dataSourceMetadata, dataSourceReader);
        DataSourceManager.getInstance().getDataSourceRepository().addDataSource(cds);
        try {
            DataSourceJndiManager.register(cds, dataSourceReader);
        }
        catch (NamingException e) {
            throw new DataSourceException("Error occurred while binding data source into JNDI context", e);
        }
    }

    @Override
    public void deleteDataSource(String dataSourceName) throws DataSourceException {
        DataSourceRepository repository = DataSourceManager.getInstance().getDataSourceRepository();
        CarbonDataSource carbonDataSource = repository.getDataSource(dataSourceName);
        repository.deleteDataSource(dataSourceName);
        try {
            DataSourceJndiManager.unregister(carbonDataSource);
        }
        catch (NamingException e) {
            throw new DataSourceException("Error occurred while unbinding data source in JNDI context", e);
        }
    }
}

