/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.rdbms.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.datasource.utils.DataSourceUtils;

public class HikariRDBMSDataSource {
    private static final String JAVAX_DATASOURCE_CLASS = "javax.sql.DataSource";
    private static final String HIKARI_JNDI_FACTORY = "com.zaxxer.hikari.HikariJNDIFactory";
    private static final Logger log = LoggerFactory.getLogger(HikariRDBMSDataSource.class);
    private static final long retryIntervalInSec = 5L;
    private HikariDataSource dataSource;
    private Reference dataSourceFactoryReference;
    private HikariConfig config;

    public HikariRDBMSDataSource(HikariConfig config) throws DataSourceException {
        this.config = config;
        this.dataSourceFactoryReference = new Reference(JAVAX_DATASOURCE_CLASS, HIKARI_JNDI_FACTORY, null);
    }

    public HikariDataSource getDataSource() {
        while (this.dataSource == null) {
            try {
                this.dataSource = new HikariDataSource(this.config);
            }
            catch (Exception e) {
                log.error("Cannot connect to JDBC URL " + this.config.getJdbcUrl() + ". Failed due to " + e.getMessage() + "retrying in " + 5L + " seconds", (Throwable)e);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    log.error(e1.getMessage(), (Throwable)e1);
                }
            }
        }
        return this.dataSource;
    }

    public Reference getDataSourceFactoryReference() throws DataSourceException {
        Map<String, String> poolConfigMap = DataSourceUtils.extractPrimitiveFieldNameValuePairs(this.config);
        poolConfigMap.forEach((key, value) -> this.dataSourceFactoryReference.add(new StringRefAddr((String)key, (String)value)));
        return this.dataSourceFactoryReference;
    }
}

