/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.rdbms.hikari.utils;

import com.zaxxer.hikari.HikariConfig;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.datasource.core.exception.DataSourceException;

public class HikariDataSourceUtils {
    private static Logger log = LoggerFactory.getLogger(HikariDataSourceUtils.class);

    public static HikariConfig buildConfiguration(Object configuration) throws DataSourceException {
        if (configuration == null) {
            throw new DataSourceException("Datasource configurations are not provided. datasource object will not be initialized!");
        }
        if (configuration instanceof Map) {
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setConnectionTimeout(30000L);
            hikariConfig.setIdleTimeout(600000L);
            hikariConfig.setMaxLifetime(1800000L);
            hikariConfig.setMinimumIdle(10);
            hikariConfig.setMinimumIdle(50);
            hikariConfig.setAutoCommit(false);
            Map configMap = (Map)configuration;
            Class<?> hikariClass = hikariConfig.getClass();
            for (Map.Entry entry : configMap.entrySet()) {
                String name = (String)entry.getKey();
                if (name == null) continue;
                try {
                    Field beanField = hikariClass.getDeclaredField(name);
                    if (!beanField.isAccessible()) {
                        AccessController.doPrivileged(() -> {
                            beanField.setAccessible(true);
                            return null;
                        });
                    }
                    if (entry.getValue() instanceof List) {
                        Class<Properties> fieldTypeClass = beanField.getType();
                        if (!fieldTypeClass.isAssignableFrom(Properties.class)) continue;
                        Properties properties = new Properties();
                        for (Object property : (ArrayList)entry.getValue()) {
                            if (!(property instanceof Map)) continue;
                            Map propertyMap = (Map)property;
                            properties.setProperty((String)propertyMap.get("name"), (String)propertyMap.get("value"));
                        }
                        beanField.set(hikariConfig, properties);
                        continue;
                    }
                    beanField.set(hikariConfig, entry.getValue());
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    log.error("Error while reading the datasource configuration key: " + name, (Throwable)e);
                }
            }
            return hikariConfig;
        }
        throw new DataSourceException("Error while reading the datasource configuration, couldn't create HikariConfig object");
    }
}

