/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.aarservices;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.aarservices.AARServiceData;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.utils.CarbonUtils;

public class ServiceUploader
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(ServiceUploader.class);

    public String uploadService(AARServiceData[] serviceDataList) throws Exception {
        String fileName = null;
        try {
            AxisConfiguration axisConfig = this.getAxisConfig();
            String repo = axisConfig.getRepository().getPath();
            if (CarbonUtils.isURL((String)repo)) {
                throw new AxisFault("Uploading services to URL repo is not supported ");
            }
            String servicesDir = axisConfig.getParameter("ServicesDirectory").getValue().toString();
            for (AARServiceData serviceData : serviceDataList) {
                fileName = serviceData.getFileName();
                StringBuffer destDir = new StringBuffer();
                if (serviceData.getServiceHierarchy() != null) {
                    String[] hierarchyParts;
                    destDir.append(repo).append(File.separator).append(servicesDir);
                    for (String part : hierarchyParts = serviceData.getServiceHierarchy().split("/")) {
                        destDir.append(File.separator).append(part);
                        File hierarchyDir = new File(destDir.toString());
                        if (hierarchyDir.exists() || hierarchyDir.mkdirs()) continue;
                        log.warn((Object)("Could not create hierarchy directory " + hierarchyDir));
                    }
                }
                this.writeToFileSystem(destDir.toString(), fileName, serviceData.getDataHandler());
            }
        }
        catch (IOException e) {
            String msg = "Error occured while uploading the service " + fileName;
            log.error((Object)msg, (Throwable)e);
            throw new Exception("Failed to upload the service archive " + fileName, e);
        }
        return "successful";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFileSystem(String path, String fileName, DataHandler dataHandler) throws Exception {
        File destFile = new File(path, fileName);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destFile);
            dataHandler.writeTo((OutputStream)fos);
            fos.flush();
            fos.close();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private String prepareHierarchy(String serviceHierarchy) {
        if (serviceHierarchy.startsWith("/")) {
            serviceHierarchy = serviceHierarchy.substring(1);
        }
        if (serviceHierarchy.endsWith("/")) {
            serviceHierarchy = serviceHierarchy.substring(0, serviceHierarchy.length() - 1);
        }
        return serviceHierarchy;
    }
}

