/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.as.monitoring.collector.jmx;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.as.monitoring.collector.jmx.AttributeMapperException;
import org.wso2.carbon.as.monitoring.collector.jmx.CollectorUtil;
import org.wso2.carbon.as.monitoring.collector.jmx.PeriodicStatCollector;
import org.wso2.carbon.as.monitoring.collector.jmx.clients.ConnectorMBeanClient;
import org.wso2.carbon.as.monitoring.collector.jmx.clients.GlobalRequestProcessorMBeanClient;
import org.wso2.carbon.as.monitoring.collector.jmx.clients.Result;
import org.wso2.carbon.as.monitoring.collector.jmx.clients.ThreadPoolMBeanClient;
import org.wso2.carbon.as.monitoring.config.BAMPublisherConfigurationException;
import org.wso2.carbon.as.monitoring.publisher.connector.ConnectorMonitoringEvent;
import org.wso2.carbon.as.monitoring.publisher.connector.ConnectorPublisher;

public class ConnectorStatCollector
extends PeriodicStatCollector {
    private static final Log LOG = LogFactory.getLog(ConnectorStatCollector.class);
    private static CollectorUtil collectorUtil = new CollectorUtil();
    private ConnectorPublisher publisher;

    public ConnectorStatCollector() {
        try {
            this.publisher = new ConnectorPublisher();
            if (!this.publisher.isPublishable()) {
                this.stop();
            }
        }
        catch (BAMPublisherConfigurationException e) {
            LOG.error((Object)"Connector monitoring will be disabled due to bad configuration.", (Throwable)e);
            this.stop();
        }
    }

    @Override
    public void run() {
        try {
            if (this.publisher == null || !this.publisher.isPublishable()) {
                return;
            }
            ConnectorMBeanClient connectorClient = new ConnectorMBeanClient();
            List<Result> connectors = connectorClient.readPossibleAttributeValues();
            ThreadPoolMBeanClient threadPoolClient = new ThreadPoolMBeanClient();
            List<Result> threadPools = threadPoolClient.readPossibleAttributeValues();
            GlobalRequestProcessorMBeanClient grpClient = new GlobalRequestProcessorMBeanClient();
            List<Result> globalRequestProcessors = grpClient.readPossibleAttributeValues();
            List<ConnectorMonitoringEvent> connectorMonitoringEvents = this.createConnectorMonitoringEvents(connectors, globalRequestProcessors, threadPools);
            for (ConnectorMonitoringEvent event : connectorMonitoringEvents) {
                this.publisher.publish(event);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception occurred while publishing connector stats: ", (Throwable)e);
        }
    }

    private List<ConnectorMonitoringEvent> createConnectorMonitoringEvents(List<Result> connectors, List<Result> globalRequestProcessors, List<Result> threadPools) throws AttributeMapperException {
        ArrayList<ConnectorMonitoringEvent> events = new ArrayList<ConnectorMonitoringEvent>();
        for (Result connector : connectors) {
            Result threadPool;
            ConnectorMonitoringEvent event = new ConnectorMonitoringEvent();
            collectorUtil.mapResultAttributesToPoJo(connector, event);
            String correlator = connector.getCorrelator();
            Result globalRequestProcessor = collectorUtil.getResultByCorrelator(globalRequestProcessors, correlator);
            if (globalRequestProcessor != null) {
                collectorUtil.mapResultAttributesToPoJo(globalRequestProcessor, event);
            }
            if ((threadPool = collectorUtil.getResultByCorrelator(threadPools, correlator)) != null) {
                collectorUtil.mapResultAttributesToPoJo(threadPool, event);
            }
            event.setTimestamp(System.currentTimeMillis());
            collectorUtil.mapMetaData(event);
            events.add(event);
        }
        return events;
    }
}

