/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.as.monitoring.config;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.wso2.carbon.as.monitoring.config.BAMPublisherConfigurationException;
import org.wso2.carbon.as.monitoring.config.StreamConfigContext;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.SAXException;

public class StreamConfigurationReader {
    public static final String CONNECTOR_DATA_STREAM_NAME = "monitoring.connector";
    public static final String WEBAPP_RESOURCE_STREAM_NAME = "monitoring.webapp.resource";
    public static final String HTTP_DATA_STREAM_NAME = "monitoring.webapp.calls";
    public static final String CONFIG_XML_FILE = "bam-publisher.xml";
    public static final String COULD_NOT_LOAD_CONFIGURATION = "could not load the bam-publisher.xml configuration";
    private static final Log LOG = LogFactory.getLog(StreamConfigurationReader.class);
    private static final String XPATH_BASE = "//bamPublisher/streams/stream[@id='%s']/%s";
    private static volatile StreamConfigurationReader streamConfigurationReader;
    private DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    private XPath xPath = XPathFactory.newInstance().newXPath();
    private Document document;
    private Map<String, StreamConfigContext> configCache = new ConcurrentHashMap<String, StreamConfigContext>();

    private StreamConfigurationReader() throws BAMPublisherConfigurationException {
        try {
            String bamConfigPath = CarbonUtils.getEtcCarbonConfigDirPath() + File.separator + CONFIG_XML_FILE;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Config File Path = " + bamConfigPath));
            }
            DocumentBuilder builder = this.builderFactory.newDocumentBuilder();
            this.document = builder.parse(bamConfigPath);
        }
        catch (ParserConfigurationException e) {
            throw new BAMPublisherConfigurationException(COULD_NOT_LOAD_CONFIGURATION, e);
        }
        catch (SAXException e) {
            throw new BAMPublisherConfigurationException(COULD_NOT_LOAD_CONFIGURATION, e);
        }
        catch (IOException e) {
            throw new BAMPublisherConfigurationException(COULD_NOT_LOAD_CONFIGURATION, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StreamConfigurationReader getInstance() throws BAMPublisherConfigurationException {
        if (streamConfigurationReader != null) return streamConfigurationReader;
        Class<StreamConfigurationReader> clazz = StreamConfigurationReader.class;
        synchronized (StreamConfigurationReader.class) {
            if (streamConfigurationReader != null) return streamConfigurationReader;
            streamConfigurationReader = new StreamConfigurationReader();
            LOG.debug((Object)"StreamConfigurationReader successfully parsed the config XML.");
            // ** MonitorExit[var0] (shouldn't be in output)
            return streamConfigurationReader;
        }
    }

    public StreamConfigContext getStreamConfiguration(String id) throws BAMPublisherConfigurationException {
        if (this.configCache.containsKey(id)) {
            LOG.debug((Object)"StreamConfiguration returning from the Cache.");
            return this.configCache.get(id);
        }
        StreamConfigContext streamConfigContext = new StreamConfigContext();
        String value = this.getValue(id, "enabled");
        streamConfigContext.setEnabled(Boolean.parseBoolean(value));
        streamConfigContext.setStreamName(this.getValue(id, "streamName"));
        streamConfigContext.setNickName(this.getValue(id, "nickName"));
        streamConfigContext.setStreamVersion(this.getValue(id, "streamVersion"));
        streamConfigContext.setUsername(this.getValue(id, "username"));
        streamConfigContext.setPassword(this.getValue(id, "password"));
        streamConfigContext.setReceiverUrl(this.getValue(id, "receiverUrl"));
        streamConfigContext.setDescription(this.getValue(id, "description"));
        this.configCache.put(id, streamConfigContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Configuration for Stream " + id + " is loaded to the cache successfully."));
        }
        return streamConfigContext;
    }

    private String getValue(String id, String property) throws BAMPublisherConfigurationException {
        String xPathQuery = String.format(XPATH_BASE, id, property);
        try {
            return this.xPath.compile(xPathQuery).evaluate(this.document);
        }
        catch (XPathExpressionException e) {
            String message = "'" + property + "' of Stream '" + id + "' cannot be read from " + CONFIG_XML_FILE + ".";
            throw new BAMPublisherConfigurationException(message, e);
        }
    }
}

