/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.as.monitoring.collector.jmx;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.management.Attribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.as.monitoring.collector.jmx.AttributeMapperException;
import org.wso2.carbon.as.monitoring.collector.jmx.clients.Result;
import org.wso2.carbon.as.monitoring.publisher.MonitoringEvent;

public class CollectorUtil {
    private static final Log LOG = LogFactory.getLog(CollectorUtil.class);

    public Result getResultByCorrelator(List<Result> results, String correlator) {
        for (Result result : results) {
            if (!correlator.equals(result.getCorrelator())) continue;
            return result;
        }
        return null;
    }

    public void mapResultAttributesToPoJo(Result result, Object event) throws AttributeMapperException {
        if (result == null) {
            throw new AttributeMapperException("parameter 'result' should not be null");
        }
        if (result.getAttributes() == null) {
            throw new AttributeMapperException("attribute list of the parameter 'result' should not be null");
        }
        List<Attribute> attributeList = result.getAttributes().asList();
        for (Attribute attribute : attributeList) {
            this.setFieldValue(event, attribute);
        }
    }

    public void mapMetaData(MonitoringEvent event) {
        String serverName;
        String serverAddress;
        block2: {
            serverAddress = "-";
            serverName = "-";
            try {
                InetAddress ip = InetAddress.getLocalHost();
                serverAddress = ip.getHostAddress();
                serverName = ip.getHostName();
            }
            catch (UnknownHostException ignored) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Exception occurred while getting local host InetAddress.", (Throwable)ignored);
            }
        }
        event.setServerAddress(serverAddress);
        event.setServerName(serverName);
        event.setClusterDomain(this.getClusterDomain());
        event.setClusterSubDomain(this.getClusterSubDomain());
    }

    public void setFieldValue(Object event, Attribute attribute) throws AttributeMapperException {
        Field field;
        Class<?> clazz = event.getClass();
        try {
            field = clazz.getDeclaredField(attribute.getName());
        }
        catch (NoSuchFieldException e) {
            throw new AttributeMapperException(attribute.getName() + " not found as a field", e);
        }
        try {
            field.setAccessible(true);
            if (!field.getType().equals(attribute.getValue().getClass())) {
                throw new AttributeMapperException("Type mismatch occurred. field = " + field.getName() + " expected = " + field.getType() + ", found = " + attribute.getValue().getClass());
            }
            field.set(event, attribute.getValue());
        }
        catch (IllegalAccessException e) {
            throw new AttributeMapperException("Error occurred while accessing field: " + field.getName() + " accessing failed.", e);
        }
    }

    private String getClusterDomain() {
        return "-";
    }

    private String getClusterSubDomain() {
        return "-";
    }
}

