/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.as.monitoring.publisher.connector;

import java.util.ArrayList;
import java.util.Collections;
import org.wso2.carbon.as.monitoring.config.BAMPublisherConfigurationException;
import org.wso2.carbon.as.monitoring.publisher.MonitoringPublisherException;
import org.wso2.carbon.as.monitoring.publisher.PublisherBase;
import org.wso2.carbon.as.monitoring.publisher.connector.ConnectorMonitoringEvent;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public class ConnectorPublisher
extends PublisherBase {
    @Override
    protected void addPayloadDataAttributes(StreamDefinition definition) {
        definition.addPayloadData("timestamp", AttributeType.LONG);
        definition.addPayloadData("connectorName", AttributeType.STRING);
        definition.addPayloadData("port", AttributeType.INT);
        definition.addPayloadData("scheme", AttributeType.STRING);
        definition.addPayloadData("bytesSent", AttributeType.LONG);
        definition.addPayloadData("bytesReceived", AttributeType.LONG);
        definition.addPayloadData("errorCount", AttributeType.INT);
        definition.addPayloadData("processingTime", AttributeType.LONG);
        definition.addPayloadData("requestCount", AttributeType.INT);
        definition.addPayloadData("connectionCount", AttributeType.LONG);
        definition.addPayloadData("currentThreadCount", AttributeType.INT);
        definition.addPayloadData("currentThreadsBusy", AttributeType.INT);
        definition.addPayloadData("keepAliveCount", AttributeType.INT);
    }

    @Override
    protected void addMetaDataAttributes(StreamDefinition definition) {
        definition.addMetaData("serverAddress", AttributeType.STRING);
        definition.addMetaData("serverName", AttributeType.STRING);
        definition.addMetaData("clusterDomain", AttributeType.STRING);
        definition.addMetaData("clusterSubDomain", AttributeType.STRING);
    }

    @Override
    protected String getDataStreamName() {
        return "monitoring.connector";
    }

    public void publish(ConnectorMonitoringEvent e) throws MonitoringPublisherException {
        ArrayList<String> metaData = new ArrayList<String>(4);
        metaData.add(this.mapNull(e.getServerAddress()));
        metaData.add(this.mapNull(e.getServerName()));
        metaData.add(this.mapNull(e.getClusterDomain()));
        metaData.add(this.mapNull(e.getClusterSubDomain()));
        ArrayList<Object> payloadData = new ArrayList<Object>(13);
        payloadData.add(this.mapNull(e.getTimestamp()));
        payloadData.add(this.mapNull(e.getConnectorName()));
        payloadData.add(this.mapNull(e.getPort()));
        payloadData.add(this.mapNull(e.getScheme()));
        payloadData.add(this.mapNull(e.getBytesSent()));
        payloadData.add(this.mapNull(e.getBytesReceived()));
        payloadData.add(this.mapNull(e.getErrorCount()));
        payloadData.add(this.mapNull(e.getProcessingTime()));
        payloadData.add(this.mapNull(e.getRequestCount()));
        payloadData.add(this.mapNull(e.getConnectionCount()));
        payloadData.add(this.mapNull(e.getCurrentThreadCount()));
        payloadData.add(this.mapNull(e.getCurrentThreadsBusy()));
        payloadData.add(this.mapNull(e.getKeepAliveCount()));
        Event event = new Event();
        event.setCorrelationData(Collections.emptyList().toArray());
        event.setMetaData(metaData.toArray());
        event.setPayloadData(payloadData.toArray());
        this.publish(event);
    }
}

