/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.as.monitoring.collector.http;

import java.io.IOException;
import java.security.Principal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.as.monitoring.config.BAMPublisherConfigurationException;
import org.wso2.carbon.as.monitoring.publisher.MonitoringPublisherException;
import org.wso2.carbon.as.monitoring.publisher.http.HttpStatPublisher;
import org.wso2.carbon.as.monitoring.publisher.http.WebappMonitoringEvent;
import org.wso2.carbon.context.CarbonContext;
import ua_parser.CachingParser;
import ua_parser.Client;
import ua_parser.Parser;

public class WebAppMonitoringPublisherValve
extends ValveBase {
    public static final String BACKSLASH = "/";
    public static final String WEBAPP = "webapp";
    private static final Log LOG = LogFactory.getLog(WebAppMonitoringPublisherValve.class);
    private volatile HttpStatPublisher publisher;
    private Parser uaParser = null;
    private Pattern pattern;

    public WebAppMonitoringPublisherValve() {
        super(true);
        try {
            this.uaParser = new CachingParser();
        }
        catch (IOException e) {
            LOG.error((Object)"Internal error in the User-Agent header parser. Some of the fields may not be included in the BAM Data Stream", (Throwable)e);
        }
        try {
            this.publisher = new HttpStatPublisher();
        }
        catch (BAMPublisherConfigurationException e) {
            LOG.error((Object)"HTTP call monitoring will be disabled. due to the error occurred.", (Throwable)e);
        }
        LOG.debug((Object)"The WebAppMonitoringPublisherValve initialized.");
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Long startTime = System.currentTimeMillis();
        this.getNext().invoke(request, response);
        long responseTime = System.currentTimeMillis() - startTime;
        if (this.publisher == null) {
            LOG.debug((Object)"HTTP call monitoring event is not processed due to bad publisher configuration.");
            return;
        }
        if (!this.publisher.isPublishable()) {
            return;
        }
        String requestURI = request.getRequestURI();
        if (this.isExcludable(requestURI)) {
            return;
        }
        try {
            WebappMonitoringEvent webappMonitoringEvent = this.prepareWebappMonitoringEventData(request, response, responseTime);
            webappMonitoringEvent.setTimestamp(startTime);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("publishing the HTTP Stat : " + webappMonitoringEvent));
            }
            this.publisher.publish(webappMonitoringEvent);
        }
        catch (MonitoringPublisherException e) {
            LOG.error((Object)("Failed to publish web app stat events to BAM : " + e.getMessage()), (Throwable)e);
        }
    }

    public void setUrlExclusionRegex(String urlExclusionRegex) {
        this.pattern = Pattern.compile(urlExclusionRegex);
    }

    private boolean isExcludable(String url) {
        if (this.pattern != null) {
            Matcher matcher = this.pattern.matcher(url);
            return matcher.find();
        }
        return true;
    }

    private WebappMonitoringEvent prepareWebappMonitoringEventData(Request request, Response response, long responseTime) {
        WebappMonitoringEvent webappMonitoringEvent = new WebappMonitoringEvent();
        String requestedURI = request.getRequestURI();
        if (requestedURI != null) {
            requestedURI = requestedURI.trim();
            String[] requestedUriParts = requestedURI.split(BACKSLASH);
            if (requestedURI.startsWith("/t/")) {
                if (requestedUriParts.length >= 4) {
                    webappMonitoringEvent.setWebappName(requestedUriParts[4]);
                    webappMonitoringEvent.setWebappOwnerTenant(requestedUriParts[2]);
                }
            } else {
                webappMonitoringEvent.setWebappOwnerTenant("carbon.super");
                if (!BACKSLASH.equals(requestedURI)) {
                    webappMonitoringEvent.setWebappName(requestedUriParts[1]);
                } else {
                    webappMonitoringEvent.setWebappName(BACKSLASH);
                }
            }
            String webappServletVersion = request.getContext().getEffectiveMajorVersion() + "." + request.getContext().getEffectiveMinorVersion();
            webappMonitoringEvent.setWebappVersion(webappServletVersion);
            String consumerName = this.extractUsername(request);
            webappMonitoringEvent.setUserId(consumerName);
            int tenantID = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            String consumerTenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            webappMonitoringEvent.setUserTenant(consumerTenantDomain);
            webappMonitoringEvent.setResourcePath(request.getPathInfo());
            webappMonitoringEvent.setHttpMethod(request.getMethod());
            webappMonitoringEvent.setContentType(request.getContentType());
            webappMonitoringEvent.setResponseContentType(response.getContentType());
            webappMonitoringEvent.setResponseHttpStatusCode(response.getStatus());
            webappMonitoringEvent.setRemoteAddress(this.getClientIpAddress(request));
            webappMonitoringEvent.setReferrer(request.getHeader("Referer"));
            webappMonitoringEvent.setRemoteUser(request.getRemoteUser());
            webappMonitoringEvent.setAuthType(request.getAuthType());
            webappMonitoringEvent.setCountry("-");
            webappMonitoringEvent.setResponseTime(responseTime);
            webappMonitoringEvent.setLanguage(request.getLocale().getLanguage());
            webappMonitoringEvent.setCountry(request.getLocale().getCountry());
            webappMonitoringEvent.setSessionId(this.extractSessionId(request));
            webappMonitoringEvent.setWebappDisplayName(request.getContext().getDisplayName());
            webappMonitoringEvent.setWebappContext(requestedURI);
            webappMonitoringEvent.setWebappType(WEBAPP);
            webappMonitoringEvent.setServerAddress(request.getServerName());
            webappMonitoringEvent.setServerName(request.getLocalName());
            webappMonitoringEvent.setTenantId(tenantID);
            webappMonitoringEvent.setRequestSizeBytes(request.getContentLength());
            webappMonitoringEvent.setResponseSizeBytes(response.getContentLength());
            this.parserUserAgent(request, webappMonitoringEvent);
        }
        return webappMonitoringEvent;
    }

    private String extractSessionId(Request request) {
        HttpSession session = request.getSession(false);
        return session != null && session.getId() != null ? session.getId() : "-";
    }

    private String extractUsername(Request request) {
        Principal principal = request.getUserPrincipal();
        String consumerName = principal != null ? principal.getName() : "anonymous.user";
        return consumerName;
    }

    private void parserUserAgent(Request request, WebappMonitoringEvent webappMonitoringEvent) {
        String userAgent = request.getHeader("user-agent");
        if (this.uaParser != null) {
            Client readableUserAgent = this.uaParser.parse(userAgent);
            webappMonitoringEvent.setUserAgentFamily(readableUserAgent.userAgent.family);
            webappMonitoringEvent.setUserAgentVersion(readableUserAgent.userAgent.major);
            webappMonitoringEvent.setOperatingSystem(readableUserAgent.os.family);
            webappMonitoringEvent.setOperatingSystemVersion(readableUserAgent.os.major);
            webappMonitoringEvent.setDeviceCategory(readableUserAgent.device.family);
        }
    }

    private String getClientIpAddress(Request request) {
        String ip = request.getHeader("X-Forwarded-For");
        ip = this.tryNextHeaderIfIpNull(request, ip, "Proxy-Client-IP");
        ip = this.tryNextHeaderIfIpNull(request, ip, "WL-Proxy-Client-IP");
        ip = this.tryNextHeaderIfIpNull(request, ip, "HTTP_CLIENT_IP");
        if ((ip = this.tryNextHeaderIfIpNull(request, ip, "HTTP_X_FORWARDED_FOR")) == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private String tryNextHeaderIfIpNull(Request request, String ip, String nextHeader) {
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            return request.getHeader(nextHeader);
        }
        return null;
    }
}

