/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.as.monitoring.collector.jmx;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.as.monitoring.collector.jmx.AttributeMapperException;
import org.wso2.carbon.as.monitoring.collector.jmx.CollectorUtil;
import org.wso2.carbon.as.monitoring.collector.jmx.PeriodicStatCollector;
import org.wso2.carbon.as.monitoring.collector.jmx.clients.CacheMBeanClient;
import org.wso2.carbon.as.monitoring.collector.jmx.clients.JspMonitorMBeanClient;
import org.wso2.carbon.as.monitoring.collector.jmx.clients.ManagerMBeanClient;
import org.wso2.carbon.as.monitoring.collector.jmx.clients.Result;
import org.wso2.carbon.as.monitoring.collector.jmx.clients.WebModuleMBeanClient;
import org.wso2.carbon.as.monitoring.config.BAMPublisherConfigurationException;
import org.wso2.carbon.as.monitoring.publisher.webappresource.WebappResourceMonitoringEvent;
import org.wso2.carbon.as.monitoring.publisher.webappresource.WebappResourcePublisher;

public class WebappResourceStatCollector
extends PeriodicStatCollector {
    private static final Log LOG = LogFactory.getLog(WebappResourceStatCollector.class);
    private static CollectorUtil collectorUtil = new CollectorUtil();
    private WebappResourcePublisher publisher;

    public WebappResourceStatCollector() {
        try {
            this.publisher = new WebappResourcePublisher();
        }
        catch (BAMPublisherConfigurationException e) {
            LOG.error((Object)"WebappResource monitoring will be disabled due to bad configuration.", (Throwable)e);
            this.stop();
        }
    }

    @Override
    public void run() {
        try {
            if (this.publisher == null || !this.publisher.isPublishable()) {
                return;
            }
            WebModuleMBeanClient webModuleMBeanClient = new WebModuleMBeanClient();
            List<Result> webModules = webModuleMBeanClient.readPossibleAttributeValues();
            ManagerMBeanClient managerMBeanClient = new ManagerMBeanClient();
            List<Result> managers = managerMBeanClient.readPossibleAttributeValues();
            CacheMBeanClient cacheMBeanClient = new CacheMBeanClient();
            List<Result> caches = cacheMBeanClient.readPossibleAttributeValues();
            JspMonitorMBeanClient jspMonitorMBeanClient = new JspMonitorMBeanClient();
            List<Result> jsps = jspMonitorMBeanClient.readPossibleAttributeValues();
            List<WebappResourceMonitoringEvent> events = this.createWebappResourceMonitoringEvents(webModules, managers, caches, jsps);
            for (WebappResourceMonitoringEvent event : events) {
                this.publisher.publish(event);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception occurred while publishing webapp resource stats.", (Throwable)e);
        }
    }

    private List<WebappResourceMonitoringEvent> createWebappResourceMonitoringEvents(List<Result> webModules, List<Result> managers, List<Result> caches, List<Result> jsps) throws AttributeMapperException {
        ArrayList<WebappResourceMonitoringEvent> events = new ArrayList<WebappResourceMonitoringEvent>();
        for (Result webModule : webModules) {
            Result jsp;
            Result cache;
            WebappResourceMonitoringEvent event = new WebappResourceMonitoringEvent();
            String correlator = webModule.getCorrelator();
            event.setContext(correlator);
            collectorUtil.mapResultAttributesToPoJo(webModule, event);
            Result manager = collectorUtil.getResultByCorrelator(managers, correlator);
            if (manager != null) {
                collectorUtil.mapResultAttributesToPoJo(manager, event);
            }
            if ((cache = collectorUtil.getResultByCorrelator(caches, correlator)) != null) {
                collectorUtil.mapResultAttributesToPoJo(cache, event);
            }
            if ((jsp = collectorUtil.getResultByCorrelator(jsps, correlator)) != null) {
                collectorUtil.mapResultAttributesToPoJo(jsp, event);
            }
            collectorUtil.mapMetaData(event);
            events.add(event);
        }
        return events;
    }
}

